/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.vialoader.impl.platform;

import com.viaversion.vialoader.impl.viaversion.VLApiBase;
import com.viaversion.vialoader.impl.viaversion.VLViaConfig;
import com.viaversion.vialoader.util.JLoggerToSLF4J;
import com.viaversion.vialoader.util.PacketTypeUtil;
import com.viaversion.vialoader.util.VLTask;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import com.viaversion.viaversion.api.configuration.ViaVersionConfig;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.ViaPlatform;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.configuration.AbstractViaConfig;
import com.viaversion.viaversion.util.VersionInfo;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;

public class ViaVersionPlatformImpl
implements ViaPlatform<UserConnection> {
    private static final Logger LOGGER = new JLoggerToSLF4J(LoggerFactory.getLogger((String)"ViaVersion"));
    private final File dataFolder;
    private final AbstractViaConfig config;
    private final ViaAPI<UserConnection> api;

    public ViaVersionPlatformImpl(File rootFolder) {
        this.dataFolder = new File(rootFolder, "ViaLoader");
        this.config = this.createConfig();
        this.api = this.createApi();
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public String getPlatformName() {
        return "ViaLoader";
    }

    public String getPlatformVersion() {
        return "4.0.6";
    }

    public String getPluginVersion() {
        return VersionInfo.getVersion();
    }

    public VLTask runAsync(Runnable runnable) {
        return new VLTask(Via.getManager().getScheduler().execute(runnable));
    }

    public VLTask runRepeatingAsync(Runnable runnable, long period) {
        return new VLTask(Via.getManager().getScheduler().scheduleRepeating(runnable, 0L, period * 50L, TimeUnit.MILLISECONDS));
    }

    public VLTask runSync(Runnable runnable) {
        return this.runAsync(runnable);
    }

    public VLTask runSync(Runnable runnable, long delay) {
        return new VLTask(Via.getManager().getScheduler().schedule(runnable, delay * 50L, TimeUnit.MILLISECONDS));
    }

    public VLTask runRepeatingSync(Runnable runnable, long period) {
        return this.runRepeatingAsync(runnable, period);
    }

    public void sendCustomPayload(UserConnection connection, String channel, byte[] message) {
        ServerboundPacketType packetType = PacketTypeUtil.getServerboundPacketType("CUSTOM_PAYLOAD", connection);
        if (packetType == null) {
            throw new IllegalStateException("Cannot send custom payload if client and server are on the same version or if the server version does not support it");
        }
        PacketWrapper customPayload = PacketWrapper.create((PacketType)packetType, (UserConnection)connection);
        customPayload.write(Types.STRING, (Object)channel);
        customPayload.write(Types.REMAINING_BYTES, (Object)message);
        customPayload.scheduleSendToServerRaw();
    }

    public boolean hasPlugin(String name) {
        return false;
    }

    public boolean couldBeReloading() {
        return false;
    }

    public boolean isProxy() {
        return true;
    }

    public ViaAPI<UserConnection> getApi() {
        return this.api;
    }

    public ViaVersionConfig getConf() {
        return this.config;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    protected AbstractViaConfig createConfig() {
        return new VLViaConfig(new File(this.dataFolder, "viaversion.yml"), this.getLogger());
    }

    protected ViaAPI<UserConnection> createApi() {
        return new VLApiBase();
    }
}

