/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.vialoader.netty;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.exception.CancelCodecException;
import com.viaversion.viaversion.exception.CancelDecoderException;
import com.viaversion.viaversion.util.PipelineUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

public class ViaDecoder
extends MessageToMessageDecoder<ByteBuf> {
    protected final UserConnection connection;

    public ViaDecoder(UserConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (!this.connection.checkIncomingPacket(in.readableBytes())) {
            throw CancelDecoderException.generate(null);
        }
        if (!this.connection.shouldTransformPacket()) {
            out.add(in.retain());
            return;
        }
        ByteBuf transformedBuf = ctx.alloc().buffer().writeBytes(in);
        try {
            this.connection.transformIncoming(transformedBuf, CancelDecoderException::generate);
            out.add(transformedBuf.retain());
        }
        finally {
            transformedBuf.release();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block2: {
            try {
                super.channelRead(ctx, msg);
            }
            catch (Throwable e) {
                if (PipelineUtil.containsCause((Throwable)e, CancelCodecException.class)) break block2;
                throw e;
            }
        }
    }

    public boolean isSharable() {
        return this.connection != null;
    }
}

