/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.vialoader.netty.viabedrock;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import net.raphimc.viabedrock.ViaBedrock;
import org.cloudburstmc.netty.channel.raknet.RakReliability;
import org.cloudburstmc.netty.channel.raknet.packet.RakMessage;

public class RakNetMessageCodec
extends MessageToMessageCodec<RakMessage, ByteBuf> {
    private static final int MINECRAFT_MESSAGE_ID = 254;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        CompositeByteBuf buf = ctx.alloc().compositeBuffer(2);
        try {
            buf.addComponent(true, ctx.alloc().ioBuffer(1).writeByte(254));
            buf.addComponent(true, in.retainedSlice());
            out.add(new RakMessage((ByteBuf)buf.retain()));
        }
        finally {
            buf.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, RakMessage in, List<Object> out) {
        if (in.channel() != 0 && in.reliability() != RakReliability.RELIABLE_ORDERED) {
            return;
        }
        ByteBuf buf = in.content();
        if (!buf.isReadable()) {
            return;
        }
        short messageId = buf.readUnsignedByte();
        if (messageId != 254) {
            ViaBedrock.getPlatform().getLogger().warning("Received invalid RakNet message id: " + messageId);
            return;
        }
        out.add(buf.readRetainedSlice(buf.readableBytes()));
    }
}

