/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_8to1_7_6_10.rewriter;

import com.viaversion.viarewind.protocol.v1_7_6_10to1_7_2_5.packet.ClientboundPackets1_7_2_5;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.Protocol1_8To1_7_6_10;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.ScoreboardTracker;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.util.ChatColorUtil;
import java.util.ArrayList;
import java.util.Optional;

public class ScoreboardPacketRewriter1_8
extends RewriterBase<Protocol1_8To1_7_6_10> {
    public ScoreboardPacketRewriter1_8(Protocol1_8To1_7_6_10 protocol) {
        super((Protocol)protocol);
    }

    protected void registerPackets() {
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_OBJECTIVE, wrapper -> {
            String name = (String)wrapper.passthrough(Types.STRING);
            if (name.length() > 16) {
                name = name.substring(0, 16);
                wrapper.set(Types.STRING, 0, (Object)name);
            }
            byte mode = (Byte)wrapper.read((Type)Types.BYTE);
            ScoreboardTracker scoreboard = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
            if (mode == 0) {
                if (scoreboard.objectiveExists(name)) {
                    wrapper.cancel();
                    return;
                }
                scoreboard.addObjective(name);
            } else if (mode == 1) {
                String sidebar;
                String username;
                Optional<Byte> color;
                if (!scoreboard.objectiveExists(name)) {
                    wrapper.cancel();
                    return;
                }
                if (scoreboard.getColorIndependentSidebar() != null && (color = scoreboard.getPlayerTeamColor(username = wrapper.user().getProtocolInfo().getUsername())).isPresent() && name.equals(sidebar = scoreboard.getColorDependentSidebar().get(color.get()))) {
                    PacketWrapper sidebarPacket = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_DISPLAY_OBJECTIVE, (UserConnection)wrapper.user());
                    sidebarPacket.write((Type)Types.BYTE, (Object)1);
                    sidebarPacket.write(Types.STRING, (Object)scoreboard.getColorIndependentSidebar());
                    sidebarPacket.scheduleSend(Protocol1_8To1_7_6_10.class);
                }
                scoreboard.removeObjective(name);
            } else if (mode == 2 && !scoreboard.objectiveExists(name)) {
                wrapper.cancel();
                return;
            }
            if (mode == 0 || mode == 2) {
                String displayName = (String)wrapper.passthrough(Types.STRING);
                if (displayName.length() > 32) {
                    wrapper.set(Types.STRING, 1, (Object)displayName.substring(0, 32));
                }
                wrapper.read(Types.STRING);
            } else {
                wrapper.write(Types.STRING, (Object)"");
            }
            wrapper.write((Type)Types.BYTE, (Object)mode);
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_SCORE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.map((Type)Types.VAR_INT, (Type)Types.BYTE);
                this.handler(wrapper -> {
                    ScoreboardTracker scoreboard = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
                    String name = (String)wrapper.get(Types.STRING, 0);
                    byte mode = (Byte)wrapper.get((Type)Types.BYTE, 0);
                    name = mode == 1 ? scoreboard.removeTeamForScore(name) : scoreboard.sendTeamForScore(name);
                    if (name.length() > 16 && (name = ChatColorUtil.stripColor((String)name)).length() > 16) {
                        name = name.substring(0, 16);
                    }
                    wrapper.set(Types.STRING, 0, (Object)name);
                    String objective = (String)wrapper.read(Types.STRING);
                    if (objective.length() > 16) {
                        objective = objective.substring(0, 16);
                    }
                    if (mode != 1) {
                        int score = (Integer)wrapper.read((Type)Types.VAR_INT);
                        wrapper.write(Types.STRING, (Object)objective);
                        wrapper.write((Type)Types.INT, (Object)score);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_DISPLAY_OBJECTIVE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.BYTE);
                this.map(Types.STRING);
                this.handler(wrapper -> {
                    int position = ((Byte)wrapper.get((Type)Types.BYTE, 0)).byteValue();
                    String name = (String)wrapper.get(Types.STRING, 0);
                    ScoreboardTracker scoreboard = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
                    if (position > 2) {
                        byte receiverTeamColor = (byte)(position - 3);
                        scoreboard.getColorDependentSidebar().put(receiverTeamColor, name);
                        String username = wrapper.user().getProtocolInfo().getUsername();
                        Optional<Byte> color = scoreboard.getPlayerTeamColor(username);
                        position = color.isPresent() && color.get() == receiverTeamColor ? 1 : -1;
                    } else if (position == 1) {
                        scoreboard.setColorIndependentSidebar(name);
                        String username = wrapper.user().getProtocolInfo().getUsername();
                        Optional<Byte> color = scoreboard.getPlayerTeamColor(username);
                        if (color.isPresent() && scoreboard.getColorDependentSidebar().containsKey(color.get())) {
                            position = -1;
                        }
                    }
                    if (position == -1) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.set((Type)Types.BYTE, 0, (Object)((byte)position));
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_PLAYER_TEAM, wrapper -> {
            String team = (String)wrapper.passthrough(Types.STRING);
            if (team == null) {
                wrapper.cancel();
                return;
            }
            ScoreboardTracker scoreboard = (ScoreboardTracker)wrapper.user().get(ScoreboardTracker.class);
            byte mode = (Byte)wrapper.passthrough((Type)Types.BYTE);
            if (mode != 0 && !scoreboard.teamExists(team)) {
                wrapper.cancel();
                return;
            }
            if (mode == 0 && scoreboard.teamExists(team)) {
                scoreboard.removeTeam(team);
                PacketWrapper removeTeam = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_PLAYER_TEAM, (UserConnection)wrapper.user());
                removeTeam.write(Types.STRING, (Object)team);
                removeTeam.write((Type)Types.BYTE, (Object)1);
                removeTeam.send(Protocol1_8To1_7_6_10.class);
            }
            if (mode == 0) {
                scoreboard.addTeam(team);
            } else if (mode == 1) {
                scoreboard.removeTeam(team);
            }
            if (mode == 0 || mode == 2) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough((Type)Types.BYTE);
                wrapper.read(Types.STRING);
                byte color = (Byte)wrapper.read((Type)Types.BYTE);
                if (mode == 2 && scoreboard.getTeamColor(team).get() != color) {
                    String sidebar = scoreboard.getColorDependentSidebar().get(color);
                    PacketWrapper sidebarPacket = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_DISPLAY_OBJECTIVE, (UserConnection)wrapper.user());
                    sidebarPacket.write((Type)Types.BYTE, (Object)1);
                    sidebarPacket.write(Types.STRING, (Object)(sidebar == null ? "" : sidebar));
                    sidebarPacket.scheduleSend(Protocol1_8To1_7_6_10.class);
                }
                scoreboard.setTeamColor(team, color);
            }
            if (mode == 0 || mode == 3 || mode == 4) {
                byte color = scoreboard.getTeamColor(team).get();
                String[] entries = (String[])wrapper.read(Types.STRING_ARRAY);
                ArrayList<String> entryList = new ArrayList<String>();
                for (String entry : entries) {
                    String username = wrapper.user().getProtocolInfo().getUsername();
                    if (mode == 4) {
                        if (!scoreboard.isPlayerInTeam(entry, team)) continue;
                        scoreboard.removePlayerFromTeam(entry, team);
                        if (entry.equals(username)) {
                            PacketWrapper sidebarPacket = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_DISPLAY_OBJECTIVE, (UserConnection)wrapper.user());
                            sidebarPacket.write((Type)Types.BYTE, (Object)1);
                            sidebarPacket.write(Types.STRING, (Object)(scoreboard.getColorIndependentSidebar() == null ? "" : scoreboard.getColorIndependentSidebar()));
                            sidebarPacket.scheduleSend(Protocol1_8To1_7_6_10.class);
                        }
                    } else {
                        scoreboard.addPlayerToTeam(entry, team);
                        if (entry.equals(username) && scoreboard.getColorDependentSidebar().containsKey(color)) {
                            PacketWrapper displayObjective = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_DISPLAY_OBJECTIVE, (UserConnection)wrapper.user());
                            displayObjective.write((Type)Types.BYTE, (Object)1);
                            displayObjective.write(Types.STRING, (Object)scoreboard.getColorDependentSidebar().get(color));
                            displayObjective.scheduleSend(Protocol1_8To1_7_6_10.class);
                        }
                    }
                    entryList.add(entry);
                }
                wrapper.write((Type)Types.SHORT, (Object)((short)entryList.size()));
                for (String entry : entryList) {
                    wrapper.write(Types.STRING, (Object)entry);
                }
            }
        });
    }
}

