/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_8to1_7_6_10.rewriter;

import com.viaversion.viarewind.api.type.RewindTypes;
import com.viaversion.viarewind.api.type.chunk.BulkChunkType1_7_6;
import com.viaversion.viarewind.api.type.chunk.ChunkType1_7_6;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.Protocol1_8To1_7_6_10;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.data.Particles1_8;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.WorldBorderEmulator;
import com.viaversion.viarewind.utils.ChatUtil;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.FixedByteArrayType;
import com.viaversion.viaversion.api.type.types.chunk.BulkChunkType1_8;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.util.ChatColorUtil;
import com.viaversion.viaversion.util.IdAndData;

public class WorldPacketRewriter1_8
extends RewriterBase<Protocol1_8To1_7_6_10> {
    public WorldPacketRewriter1_8(Protocol1_8To1_7_6_10 protocol) {
        super((Protocol)protocol);
    }

    protected void registerPackets() {
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.LEVEL_CHUNK, wrapper -> {
            ClientWorld world = wrapper.user().getClientWorld(Protocol1_8To1_7_6_10.class);
            Chunk chunk = (Chunk)wrapper.read((Type)ChunkType1_8.forEnvironment((Environment)world.getEnvironment()));
            ((Protocol1_8To1_7_6_10)this.protocol).getItemRewriter().handleChunk(chunk);
            wrapper.write((Type)ChunkType1_7_6.TYPE, (Object)chunk);
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.BLOCK_UPDATE, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.U_BYTE_POSITION);
                this.handler(wrapper -> {
                    int data = (Integer)wrapper.read((Type)Types.VAR_INT);
                    data = ((Protocol1_8To1_7_6_10)WorldPacketRewriter1_8.this.protocol).getItemRewriter().handleBlockId(data);
                    wrapper.write((Type)Types.VAR_INT, (Object)IdAndData.getId((int)data));
                    wrapper.write((Type)Types.UNSIGNED_BYTE, (Object)((short)IdAndData.getData((int)data)));
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.CHUNK_BLOCKS_UPDATE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.handler(wrapper -> {
                    BlockChangeRecord[] records = (BlockChangeRecord[])wrapper.read(Types.BLOCK_CHANGE_ARRAY);
                    wrapper.write((Type)Types.SHORT, (Object)((short)records.length));
                    wrapper.write((Type)Types.INT, (Object)(records.length * 4));
                    for (BlockChangeRecord record : records) {
                        wrapper.write((Type)Types.SHORT, (Object)((short)(record.getSectionX() << 12 | record.getSectionZ() << 8 | record.getY())));
                        wrapper.write((Type)Types.SHORT, (Object)((short)((Protocol1_8To1_7_6_10)WorldPacketRewriter1_8.this.protocol).getItemRewriter().handleBlockId(record.getBlockId())));
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.BLOCK_EVENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.SHORT_POSITION);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.VAR_INT);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.BLOCK_DESTRUCTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.INT_POSITION);
                this.map((Type)Types.BYTE);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.MAP_BULK_CHUNK, wrapper -> {
            Chunk[] chunks;
            for (Chunk chunk : chunks = (Chunk[])wrapper.read(BulkChunkType1_8.TYPE)) {
                ((Protocol1_8To1_7_6_10)this.protocol).getItemRewriter().handleChunk(chunk);
            }
            wrapper.write((Type)BulkChunkType1_7_6.TYPE, (Object)chunks);
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.LEVEL_EVENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.BYTE_POSITION);
                this.map((Type)Types.INT);
                this.map((Type)Types.BOOLEAN);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.LEVEL_PARTICLES, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    int particleId = (Integer)wrapper.read((Type)Types.INT);
                    Particles1_8 particle = Particles1_8.find(particleId);
                    if (particle == null) {
                        particle = Particles1_8.CRIT;
                    }
                    wrapper.write(Types.STRING, (Object)particle.name);
                });
                this.read((Type)Types.BOOLEAN);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.INT);
                this.handler(wrapper -> {
                    Object name = (String)wrapper.get(Types.STRING, 0);
                    Particles1_8 particle = Particles1_8.find((String)name);
                    if (particle == Particles1_8.ICON_CRACK || particle == Particles1_8.BLOCK_CRACK || particle == Particles1_8.BLOCK_DUST) {
                        int data;
                        int id = (Integer)wrapper.read((Type)Types.VAR_INT);
                        int n = data = particle == Particles1_8.ICON_CRACK ? (Integer)wrapper.read((Type)Types.VAR_INT) : id / 4096;
                        if ((id %= 4096) >= 256 && id <= 422 || id >= 2256 && id <= 2267) {
                            particle = Particles1_8.ICON_CRACK;
                        } else if (id >= 0 && id <= 164 || id >= 170 && id <= 175) {
                            if (particle == Particles1_8.ICON_CRACK) {
                                particle = Particles1_8.BLOCK_CRACK;
                            }
                        } else {
                            wrapper.cancel();
                            return;
                        }
                        name = particle.name + "_" + id + "_" + data;
                    }
                    wrapper.set(Types.STRING, 0, name);
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.UPDATE_SIGN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.SHORT_POSITION);
                this.handler(wrapper -> {
                    for (int i = 0; i < 4; ++i) {
                        String line = (String)wrapper.read(Types.STRING);
                        line = ChatUtil.jsonToLegacy(line);
                        if ((line = ChatUtil.removeUnusedColor(line, '0')).length() > 15 && (line = ChatColorUtil.stripColor((String)line)).length() > 15) {
                            line = line.substring(0, 15);
                        }
                        wrapper.write(Types.STRING, (Object)line);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.MAP_ITEM_DATA, wrapper -> {
            wrapper.cancel();
            int id = (Integer)wrapper.read((Type)Types.VAR_INT);
            byte scale = (Byte)wrapper.read((Type)Types.BYTE);
            int iconCount = (Integer)wrapper.read((Type)Types.VAR_INT);
            byte[] icons = new byte[iconCount * 4];
            for (int i = 0; i < iconCount; ++i) {
                byte directionAndType = (Byte)wrapper.read((Type)Types.BYTE);
                icons[i * 4] = (byte)(directionAndType >> 4 & 0xF);
                icons[i * 4 + 1] = (Byte)wrapper.read((Type)Types.BYTE);
                icons[i * 4 + 2] = (Byte)wrapper.read((Type)Types.BYTE);
                icons[i * 4 + 3] = (byte)(directionAndType & 0xF);
            }
            int columns = ((Short)wrapper.read((Type)Types.UNSIGNED_BYTE)).shortValue();
            if (columns > 0) {
                int rows = ((Short)wrapper.read((Type)Types.UNSIGNED_BYTE)).shortValue();
                short x = (Short)wrapper.read((Type)Types.UNSIGNED_BYTE);
                short z = (Short)wrapper.read((Type)Types.UNSIGNED_BYTE);
                byte[] data = (byte[])wrapper.read(Types.BYTE_ARRAY_PRIMITIVE);
                for (int column = 0; column < columns; ++column) {
                    byte[] columnData = new byte[rows + 3];
                    columnData[0] = 0;
                    columnData[1] = (byte)(x + column);
                    columnData[2] = (byte)z;
                    for (int i = 0; i < rows; ++i) {
                        columnData[i + 3] = data[column + i * columns];
                    }
                    PacketWrapper mapData = PacketWrapper.create((PacketType)ClientboundPackets1_8.MAP_ITEM_DATA, (UserConnection)wrapper.user());
                    mapData.write((Type)Types.VAR_INT, (Object)id);
                    mapData.write((Type)Types.SHORT, (Object)((short)columnData.length));
                    mapData.write((Type)new FixedByteArrayType(columnData.length), (Object)columnData);
                    mapData.send(Protocol1_8To1_7_6_10.class);
                }
            }
            if (iconCount > 0) {
                byte[] iconData = new byte[iconCount * 3 + 1];
                iconData[0] = 1;
                for (int i = 0; i < iconCount; ++i) {
                    iconData[i * 3 + 1] = (byte)(icons[i * 4] << 4 | icons[i * 4 + 3] & 0xF);
                    iconData[i * 3 + 2] = icons[i * 4 + 1];
                    iconData[i * 3 + 3] = icons[i * 4 + 2];
                }
                PacketWrapper mapData = PacketWrapper.create((PacketType)ClientboundPackets1_8.MAP_ITEM_DATA, (UserConnection)wrapper.user());
                mapData.write((Type)Types.VAR_INT, (Object)id);
                mapData.write((Type)Types.SHORT, (Object)((short)iconData.length));
                mapData.write((Type)new FixedByteArrayType(iconData.length), (Object)iconData);
                mapData.send(Protocol1_8To1_7_6_10.class);
            }
            PacketWrapper mapData = PacketWrapper.create((PacketType)ClientboundPackets1_8.MAP_ITEM_DATA, (UserConnection)wrapper.user());
            mapData.write((Type)Types.VAR_INT, (Object)id);
            mapData.write((Type)Types.SHORT, (Object)2);
            mapData.write((Type)new FixedByteArrayType(2), (Object)new byte[]{2, scale});
            mapData.send(Protocol1_8To1_7_6_10.class);
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.BLOCK_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.SHORT_POSITION);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map(Types.NAMED_COMPOUND_TAG, RewindTypes.COMPRESSED_NBT);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).cancelClientbound((ClientboundPacketType)ClientboundPackets1_8.CHANGE_DIFFICULTY);
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_BORDER, null, wrapper -> {
            WorldBorderEmulator emulator = (WorldBorderEmulator)wrapper.user().get(WorldBorderEmulator.class);
            wrapper.cancel();
            int action = (Integer)wrapper.read((Type)Types.VAR_INT);
            if (action == 0) {
                emulator.setSize((Double)wrapper.read((Type)Types.DOUBLE));
            } else if (action == 1) {
                emulator.lerpSize((Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Long)wrapper.read((Type)Types.VAR_LONG));
            } else if (action == 2) {
                emulator.setCenter((Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE));
            } else if (action == 3) {
                emulator.init((Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Double)wrapper.read((Type)Types.DOUBLE), (Long)wrapper.read((Type)Types.VAR_LONG));
            }
        });
    }
}

