/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_9to1_8.data;

import com.viaversion.viarewind.protocol.v1_7_6_10to1_7_2_5.packet.ClientboundPackets1_7_2_5;
import com.viaversion.viarewind.protocol.v1_9to1_8.Protocol1_9To1_8;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.legacy.bossbar.BossBar;
import com.viaversion.viaversion.api.legacy.bossbar.BossColor;
import com.viaversion.viaversion.api.legacy.bossbar.BossFlag;
import com.viaversion.viaversion.api.legacy.bossbar.BossStyle;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_8;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;

public class WitherBossBar
implements BossBar {
    private static int highestId = 2147473647;
    private final UUID uuid;
    private final UserConnection connection;
    private final int entityId = highestId++;
    private String title;
    private float health;
    private boolean visible = false;
    private double locX;
    private double locY;
    private double locZ;

    public WitherBossBar(UserConnection connection, UUID uuid, String title, float health) {
        this.connection = connection;
        this.uuid = uuid;
        this.title = title;
        this.health = health;
    }

    public String getTitle() {
        return this.title;
    }

    public BossBar setTitle(String title) {
        this.title = title;
        if (this.visible) {
            this.updateEntityData();
        }
        return this;
    }

    public float getHealth() {
        return this.health;
    }

    public BossBar setHealth(float health) {
        this.health = health;
        if (this.health <= 0.0f) {
            this.health = 1.0E-4f;
        }
        if (this.visible) {
            this.updateEntityData();
        }
        return this;
    }

    public BossColor getColor() {
        return null;
    }

    public BossBar setColor(BossColor bossColor) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support color");
    }

    public BossStyle getStyle() {
        return null;
    }

    public BossBar setStyle(BossStyle bossStyle) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support styles");
    }

    public BossBar addPlayer(UUID uuid) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only for one UserConnection!");
    }

    public BossBar addConnection(UserConnection userConnection) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only for one UserConnection!");
    }

    public BossBar removePlayer(UUID uuid) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only for one UserConnection!");
    }

    public BossBar removeConnection(UserConnection userConnection) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only for one UserConnection!");
    }

    public BossBar addFlag(BossFlag bossFlag) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support flags");
    }

    public BossBar removeFlag(BossFlag bossFlag) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support flags");
    }

    public boolean hasFlag(BossFlag bossFlag) {
        return false;
    }

    public Set<UUID> getPlayers() {
        return Collections.singleton(this.connection.getProtocolInfo().getUuid());
    }

    public Set<UserConnection> getConnections() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is only for one UserConnection!");
    }

    public BossBar show() {
        if (!this.visible) {
            this.addWither();
            this.visible = true;
        }
        return this;
    }

    public BossBar hide() {
        if (this.visible) {
            this.removeWither();
            this.visible = false;
        }
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public UUID getId() {
        return this.uuid;
    }

    public void setLocation(double x, double y, double z) {
        this.locX = x;
        this.locY = y;
        this.locZ = z;
        this.updateLocation();
    }

    private void addWither() {
        PacketWrapper addMob = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.ADD_MOB, (UserConnection)this.connection);
        addMob.write((Type)Types.VAR_INT, (Object)this.entityId);
        addMob.write((Type)Types.UNSIGNED_BYTE, (Object)64);
        addMob.write((Type)Types.INT, (Object)((int)(this.locX * 32.0)));
        addMob.write((Type)Types.INT, (Object)((int)(this.locY * 32.0)));
        addMob.write((Type)Types.INT, (Object)((int)(this.locZ * 32.0)));
        addMob.write((Type)Types.BYTE, (Object)0);
        addMob.write((Type)Types.BYTE, (Object)0);
        addMob.write((Type)Types.BYTE, (Object)0);
        addMob.write((Type)Types.SHORT, (Object)0);
        addMob.write((Type)Types.SHORT, (Object)0);
        addMob.write((Type)Types.SHORT, (Object)0);
        ArrayList<EntityData> entityData = new ArrayList<EntityData>();
        entityData.add(new EntityData(0, (EntityDataType)EntityDataTypes1_8.BYTE, (Object)32));
        entityData.add(new EntityData(2, (EntityDataType)EntityDataTypes1_8.STRING, (Object)this.title));
        entityData.add(new EntityData(3, (EntityDataType)EntityDataTypes1_8.BYTE, (Object)1));
        entityData.add(new EntityData(6, (EntityDataType)EntityDataTypes1_8.FLOAT, (Object)Float.valueOf(this.health * 300.0f)));
        entityData.add(new EntityData(20, (EntityDataType)EntityDataTypes1_8.INT, (Object)880));
        addMob.write(Types.ENTITY_DATA_LIST1_8, entityData);
        addMob.scheduleSend(Protocol1_9To1_8.class);
    }

    private void updateLocation() {
        PacketWrapper teleportEntity = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.TELEPORT_ENTITY, (UserConnection)this.connection);
        teleportEntity.write((Type)Types.VAR_INT, (Object)this.entityId);
        teleportEntity.write((Type)Types.INT, (Object)((int)(this.locX * 32.0)));
        teleportEntity.write((Type)Types.INT, (Object)((int)(this.locY * 32.0)));
        teleportEntity.write((Type)Types.INT, (Object)((int)(this.locZ * 32.0)));
        teleportEntity.write((Type)Types.BYTE, (Object)0);
        teleportEntity.write((Type)Types.BYTE, (Object)0);
        teleportEntity.write((Type)Types.BOOLEAN, (Object)false);
        teleportEntity.scheduleSend(Protocol1_9To1_8.class);
    }

    private void updateEntityData() {
        PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_ENTITY_DATA, (UserConnection)this.connection);
        setEntityData.write((Type)Types.VAR_INT, (Object)this.entityId);
        ArrayList<EntityData> entityData = new ArrayList<EntityData>();
        entityData.add(new EntityData(2, (EntityDataType)EntityDataTypes1_8.STRING, (Object)this.title));
        entityData.add(new EntityData(6, (EntityDataType)EntityDataTypes1_8.FLOAT, (Object)Float.valueOf(this.health * 300.0f)));
        setEntityData.write(Types.ENTITY_DATA_LIST1_8, entityData);
        setEntityData.scheduleSend(Protocol1_9To1_8.class);
    }

    private void removeWither() {
        PacketWrapper removeEntity = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.REMOVE_ENTITIES, (UserConnection)this.connection);
        removeEntity.write(Types.VAR_INT_ARRAY_PRIMITIVE, (Object)new int[]{this.entityId});
        removeEntity.scheduleSend(Protocol1_9To1_8.class);
    }

    public void setPlayerLocation(double posX, double posY, double posZ, float yaw, float pitch) {
        double yawR = Math.toRadians(yaw);
        double pitchR = Math.toRadians(pitch);
        this.setLocation(posX -= Math.cos(pitchR) * Math.sin(yawR) * 48.0, posY -= Math.sin(pitchR) * 48.0, posZ += Math.cos(pitchR) * Math.cos(yawR) * 48.0);
    }
}

