/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.data;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntArrayTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.BiMappings;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.data.FullMappingsBase;
import com.viaversion.viaversion.api.data.IdentityMappings;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.data.MappingDataLoader;
import com.viaversion.viaversion.api.data.Mappings;
import com.viaversion.viaversion.api.data.ParticleMappings;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.TagData;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MappingDataBase
implements MappingData {
    protected final String unmappedVersion;
    protected final String mappedVersion;
    protected FullMappings argumentTypeMappings;
    protected FullMappings entityMappings;
    protected FullMappings recipeSerializerMappings;
    protected FullMappings itemDataSerializerMappings;
    protected FullMappings attributeMappings;
    protected FullMappings blockEntityMappings;
    protected ParticleMappings particleMappings;
    protected BiMappings itemMappings;
    protected BiMappings blockMappings;
    protected Mappings blockStateMappings;
    protected Mappings soundMappings;
    protected Mappings statisticsMappings;
    protected Mappings enchantmentMappings;
    protected Mappings paintingMappings;
    protected Mappings menuMappings;
    protected Map<RegistryType, List<TagData>> tags;
    protected IntSet changedBlocks;

    public MappingDataBase(String unmappedVersion, String mappedVersion) {
        this.unmappedVersion = unmappedVersion;
        this.mappedVersion = mappedVersion;
    }

    @Override
    public void load() {
        IntArrayTag changedBlocks;
        if (Via.getManager().isDebug()) {
            this.getLogger().info("Loading " + this.unmappedVersion + " -> " + this.mappedVersion + " mappings...");
        }
        CompoundTag data = this.readMappingsFile("mappings-" + this.unmappedVersion + "to" + this.mappedVersion + ".nbt");
        this.blockStateMappings = this.loadMappings(data, "blockstates");
        this.statisticsMappings = this.loadMappings(data, "statistics");
        this.menuMappings = this.loadMappings(data, "menus");
        this.enchantmentMappings = this.loadMappings(data, "enchantments");
        this.paintingMappings = this.loadMappings(data, "paintings");
        CompoundTag unmappedIdentifierData = this.readUnmappedIdentifiersFile("identifiers-" + this.unmappedVersion + ".nbt");
        CompoundTag mappedIdentifierData = this.readMappedIdentifiersFile("identifiers-" + this.mappedVersion + ".nbt");
        if (unmappedIdentifierData != null && mappedIdentifierData != null) {
            this.itemMappings = this.loadFullOrBiMappings(data, unmappedIdentifierData, mappedIdentifierData, "items");
            this.blockMappings = this.loadFullOrBiMappings(data, unmappedIdentifierData, mappedIdentifierData, "blocks");
            this.soundMappings = this.loadFullOrBiMappings(data, unmappedIdentifierData, mappedIdentifierData, "sounds");
            this.entityMappings = this.loadFullMappings(data, unmappedIdentifierData, mappedIdentifierData, "entities");
            this.argumentTypeMappings = this.loadFullMappings(data, unmappedIdentifierData, mappedIdentifierData, "argumenttypes");
            this.recipeSerializerMappings = this.loadFullMappings(data, unmappedIdentifierData, mappedIdentifierData, "recipe_serializers");
            this.itemDataSerializerMappings = this.loadFullMappings(data, unmappedIdentifierData, mappedIdentifierData, "data_component_type");
            this.attributeMappings = this.loadFullMappings(data, unmappedIdentifierData, mappedIdentifierData, "attributes");
            this.blockEntityMappings = this.loadFullMappings(data, unmappedIdentifierData, mappedIdentifierData, "blockentities");
            List<String> unmappedParticles = this.identifiersFromGlobalIds(unmappedIdentifierData, "particles");
            List<String> mappedParticles = this.identifiersFromGlobalIds(mappedIdentifierData, "particles");
            if (unmappedParticles != null && mappedParticles != null) {
                Mappings particleMappings = this.loadMappings(data, "particles");
                if (particleMappings == null) {
                    particleMappings = new IdentityMappings(unmappedParticles.size(), mappedParticles.size());
                }
                this.particleMappings = new ParticleMappings(unmappedParticles, mappedParticles, particleMappings);
            }
        } else {
            this.itemMappings = this.loadBiMappings(data, "items");
            this.blockMappings = this.loadBiMappings(data, "blocks");
            this.soundMappings = this.loadMappings(data, "sounds");
        }
        CompoundTag tagsTag = data.getCompoundTag("tags");
        if (tagsTag != null) {
            this.tags = new EnumMap<RegistryType, List<TagData>>(RegistryType.class);
            this.loadTags(RegistryType.ITEM, tagsTag);
            this.loadTags(RegistryType.BLOCK, tagsTag);
            this.loadTags(RegistryType.ENTITY, tagsTag);
        }
        if ((changedBlocks = data.getIntArrayTag("changed_blocks")) != null) {
            this.changedBlocks = new IntOpenHashSet(changedBlocks.getValue());
        }
        this.loadExtras(data);
    }

    protected @Nullable List<String> identifiersFromGlobalIds(CompoundTag mappingsTag, String key) {
        return MappingDataLoader.INSTANCE.identifiersFromGlobalIds(mappingsTag, key);
    }

    protected @Nullable CompoundTag readMappingsFile(String name) {
        return MappingDataLoader.INSTANCE.loadNBT(name);
    }

    protected @Nullable CompoundTag readUnmappedIdentifiersFile(String name) {
        return MappingDataLoader.INSTANCE.loadNBT(name, true);
    }

    protected @Nullable CompoundTag readMappedIdentifiersFile(String name) {
        return MappingDataLoader.INSTANCE.loadNBT(name, true);
    }

    protected @Nullable Mappings loadMappings(CompoundTag data, String key) {
        return MappingDataLoader.INSTANCE.loadMappings(data, key);
    }

    protected @Nullable BiMappings loadFullOrBiMappings(CompoundTag data, CompoundTag unmappedIdentifiersTag, CompoundTag mappedIdentifiersTag, String key) {
        FullMappings mappings = this.loadFullMappings(data, unmappedIdentifiersTag, mappedIdentifiersTag, key);
        return mappings != null ? mappings : this.loadBiMappings(data, key);
    }

    protected @Nullable FullMappings loadFullMappings(CompoundTag data, CompoundTag unmappedIdentifiersTag, CompoundTag mappedIdentifiersTag, String key) {
        if (!unmappedIdentifiersTag.contains(key) || !mappedIdentifiersTag.contains(key)) {
            return null;
        }
        List<String> unmappedIdentifiers = this.identifiersFromGlobalIds(unmappedIdentifiersTag, key);
        List<String> mappedIdentifiers = this.identifiersFromGlobalIds(mappedIdentifiersTag, key);
        Mappings mappings = this.loadBiMappings(data, key);
        if (mappings == null) {
            mappings = new IdentityMappings(unmappedIdentifiers.size(), mappedIdentifiers.size());
        }
        return new FullMappingsBase(unmappedIdentifiers, mappedIdentifiers, mappings);
    }

    protected @Nullable BiMappings loadBiMappings(CompoundTag data, String key) {
        Mappings mappings = this.loadMappings(data, key);
        return mappings != null ? BiMappings.of(mappings) : null;
    }

    private void loadTags(RegistryType type, CompoundTag data) {
        CompoundTag tag = data.getCompoundTag(type.identifier());
        if (tag == null) {
            return;
        }
        ArrayList<TagData> tagsList = new ArrayList<TagData>(this.tags.size());
        for (Map.Entry<String, Tag> entry : tag.entrySet()) {
            IntArrayTag entries = (IntArrayTag)entry.getValue();
            tagsList.add(new TagData(entry.getKey(), entries.getValue()));
        }
        this.tags.put(type, tagsList);
    }

    @Override
    public int getNewBlockStateId(int id) {
        return this.checkValidity(id, this.blockStateMappings.getNewId(id), "blockstate");
    }

    @Override
    public int getNewBlockId(int id) {
        return this.checkValidity(id, this.blockMappings.getNewId(id), "block");
    }

    @Override
    public int getOldBlockId(int id) {
        return this.blockMappings.inverse().getNewIdOrDefault(id, 1);
    }

    @Override
    public int getNewItemId(int id) {
        return this.checkValidity(id, this.itemMappings.getNewId(id), "item");
    }

    @Override
    public int getOldItemId(int id) {
        return this.itemMappings.inverse().getNewIdOrDefault(id, 1);
    }

    @Override
    public int getNewParticleId(int id) {
        return this.checkValidity(id, this.particleMappings.getNewId(id), "particles");
    }

    @Override
    public int getNewAttributeId(int id) {
        return this.checkValidity(id, this.attributeMappings.getNewId(id), "attributes");
    }

    @Override
    public int getNewSoundId(int id) {
        return this.checkValidity(id, this.soundMappings.getNewId(id), "sound");
    }

    @Override
    public int getOldSoundId(int id) {
        return this.soundMappings.inverse().getNewIdOrDefault(id, 0);
    }

    @Override
    public @Nullable List<TagData> getTags(RegistryType type) {
        return this.tags != null ? this.tags.get(type) : null;
    }

    @Override
    public @Nullable BiMappings getItemMappings() {
        return this.itemMappings;
    }

    @Override
    public @Nullable FullMappings getFullItemMappings() {
        BiMappings biMappings = this.itemMappings;
        if (biMappings instanceof FullMappings) {
            FullMappings fullItemMappings = (FullMappings)biMappings;
            return fullItemMappings;
        }
        return null;
    }

    @Override
    public @Nullable ParticleMappings getParticleMappings() {
        return this.particleMappings;
    }

    @Override
    public @Nullable Mappings getBlockMappings() {
        return this.blockMappings;
    }

    @Override
    public @Nullable FullMappings getFullBlockMappings() {
        BiMappings biMappings = this.blockMappings;
        if (biMappings instanceof FullMappings) {
            FullMappings fullBlockMappings = (FullMappings)biMappings;
            return fullBlockMappings;
        }
        return null;
    }

    @Override
    public @Nullable FullMappings getBlockEntityMappings() {
        return this.blockEntityMappings;
    }

    @Override
    public @Nullable Mappings getBlockStateMappings() {
        return this.blockStateMappings;
    }

    @Override
    public @Nullable Mappings getSoundMappings() {
        return this.soundMappings;
    }

    @Override
    public @Nullable FullMappings getFullSoundMappings() {
        Mappings mappings = this.soundMappings;
        if (mappings instanceof FullMappings) {
            FullMappings fullSoundMappings = (FullMappings)mappings;
            return fullSoundMappings;
        }
        return null;
    }

    @Override
    public @Nullable Mappings getStatisticsMappings() {
        return this.statisticsMappings;
    }

    @Override
    public @Nullable Mappings getMenuMappings() {
        return this.menuMappings;
    }

    @Override
    public @Nullable Mappings getEnchantmentMappings() {
        return this.enchantmentMappings;
    }

    @Override
    public @Nullable FullMappings getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    public @Nullable FullMappings getEntityMappings() {
        return this.entityMappings;
    }

    @Override
    public @Nullable FullMappings getArgumentTypeMappings() {
        return this.argumentTypeMappings;
    }

    @Override
    public @Nullable FullMappings getDataComponentSerializerMappings() {
        return this.itemDataSerializerMappings;
    }

    @Override
    public @Nullable Mappings getPaintingMappings() {
        return this.paintingMappings;
    }

    @Override
    public @Nullable FullMappings getRecipeSerializerMappings() {
        return this.recipeSerializerMappings;
    }

    @Override
    public @Nullable IntSet changedBlocks() {
        return this.changedBlocks;
    }

    protected Logger getLogger() {
        return Via.getPlatform().getLogger();
    }

    protected int checkValidity(int id, int mappedId, String type) {
        if (mappedId == -1) {
            if (!Via.getConfig().isSuppressConversionWarnings()) {
                this.getLogger().warning(String.format("Missing %s %s for %s %s %d", this.mappedVersion, type, this.unmappedVersion, type, id));
            }
            return 0;
        }
        return mappedId;
    }

    protected void loadExtras(CompoundTag data) {
    }
}

