/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import io.netty.buffer.ByteBuf;

public record AttackRange(float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin, float mobFactor) {
    public static final Type<AttackRange> TYPE = new Type<AttackRange>(AttackRange.class){

        @Override
        public AttackRange read(ByteBuf buffer) {
            float minRange = Types.FLOAT.readPrimitive(buffer);
            float maxRange = Types.FLOAT.readPrimitive(buffer);
            float minCreativeRange = Types.FLOAT.readPrimitive(buffer);
            float maxCreativeRange = Types.FLOAT.readPrimitive(buffer);
            float hitboxMargin = Types.FLOAT.readPrimitive(buffer);
            float mobFactor = Types.FLOAT.readPrimitive(buffer);
            return new AttackRange(minRange, maxRange, minCreativeRange, maxCreativeRange, hitboxMargin, mobFactor);
        }

        @Override
        public void write(ByteBuf buffer, AttackRange value) {
            Types.FLOAT.writePrimitive(buffer, value.minRange);
            Types.FLOAT.writePrimitive(buffer, value.maxRange);
            Types.FLOAT.writePrimitive(buffer, value.minCreativeRange);
            Types.FLOAT.writePrimitive(buffer, value.maxCreativeRange);
            Types.FLOAT.writePrimitive(buffer, value.hitboxMargin);
            Types.FLOAT.writePrimitive(buffer, value.mobFactor);
        }

        @Override
        public void write(Ops ops, AttackRange AttackRange2) {
            ops.writeMap(map -> map.writeOptional("min_range", Types.FLOAT, Float.valueOf(AttackRange2.minRange), Float.valueOf(0.0f)).writeOptional("max_range", Types.FLOAT, Float.valueOf(AttackRange2.maxRange), Float.valueOf(3.0f)).writeOptional("min_creative_reach", Types.FLOAT, Float.valueOf(AttackRange2.minCreativeRange), Float.valueOf(0.0f)).writeOptional("max_creative_reach", Types.FLOAT, Float.valueOf(AttackRange2.maxCreativeRange), Float.valueOf(5.0f)).writeOptional("hitbox_margin", Types.FLOAT, Float.valueOf(AttackRange2.hitboxMargin), Float.valueOf(0.3f)).writeOptional("mob_factor", Types.FLOAT, Float.valueOf(AttackRange2.mobFactor), Float.valueOf(1.0f)));
        }
    };
}

