/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types;

import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.VarIntType;
import com.viaversion.viaversion.util.MathUtil;

public final class EnumType
extends VarIntType {
    private final String[] names;
    private final Fallback fallback;

    public EnumType(String ... names) {
        this(Fallback.ZERO, names);
    }

    public EnumType(Fallback fallback, String ... names) {
        this.names = names;
        this.fallback = fallback;
    }

    @Override
    public void write(Ops ops, Integer value) {
        Types.STRING.write(ops, this.nameFromId(value));
    }

    public String[] names() {
        return this.names;
    }

    public String nameFromId(int id) {
        if (id < 0 || id >= this.names.length) {
            return switch (this.fallback) {
                default -> throw new IncompatibleClassChangeError();
                case Fallback.ZERO -> this.names[0];
                case Fallback.WRAP -> this.names[Math.floorMod(id, this.names.length)];
                case Fallback.CLAMP -> this.names[MathUtil.clamp(id, 0, this.names.length - 1)];
            };
        }
        return this.names[id];
    }

    public int idFromName(String name) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            return i;
        }
        return switch (this.fallback) {
            default -> throw new IncompatibleClassChangeError();
            case Fallback.ZERO -> 0;
            case Fallback.WRAP -> Math.floorMod(name.hashCode(), this.names.length);
            case Fallback.CLAMP -> this.names.length - 1;
        };
    }

    public static enum Fallback {
        ZERO,
        WRAP,
        CLAMP;

    }
}

