/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.util.ArrayUtil;
import com.viaversion.viaversion.util.Copyable;
import io.netty.buffer.ByteBuf;

public record CustomModelData1_21_4(float[] floats, boolean[] booleans, String[] strings, int[] colors) implements Copyable
{
    public static final Type<CustomModelData1_21_4> TYPE = new Type<CustomModelData1_21_4>(CustomModelData1_21_4.class){

        @Override
        public CustomModelData1_21_4 read(ByteBuf buffer) {
            float[] floats = (float[])Types.FLOAT_ARRAY_PRIMITIVE.read(buffer);
            boolean[] booleans = (boolean[])Types.BOOLEAN_ARRAY_PRIMITIVE.read(buffer);
            String[] strings = (String[])Types.STRING_ARRAY.read(buffer);
            int[] colors = (int[])Types.INT_ARRAY_PRIMITIVE.read(buffer);
            return new CustomModelData1_21_4(floats, booleans, strings, colors);
        }

        @Override
        public void write(ByteBuf buffer, CustomModelData1_21_4 value) {
            Types.FLOAT_ARRAY_PRIMITIVE.write(buffer, value.floats());
            Types.BOOLEAN_ARRAY_PRIMITIVE.write(buffer, value.booleans());
            Types.STRING_ARRAY.write(buffer, value.strings());
            Types.INT_ARRAY_PRIMITIVE.write(buffer, value.colors());
        }

        @Override
        public void write(Ops ops, CustomModelData1_21_4 value) {
            ops.writeMap(map -> map.writeOptional("floats", new ArrayType<Float>(Types.FLOAT), ArrayUtil.boxedArray(value.floats), new Float[0]).writeOptional("flags", new ArrayType<Boolean>(Types.BOOLEAN), ArrayUtil.boxedArray(value.booleans), new Boolean[0]).writeOptional("strings", Types.STRING_ARRAY, value.strings(), new String[0]).writeOptional("colors", new ArrayType<Integer>(Types.INT), ArrayUtil.boxedArray(value.colors), new Integer[0]));
        }
    };

    @Override
    public CustomModelData1_21_4 copy() {
        return new CustomModelData1_21_4(Copyable.copy(this.floats), Copyable.copy(this.booleans), Copyable.copy(this.strings), Copyable.copy(this.colors));
    }
}

