/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.platform;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import com.viaversion.viaversion.api.configuration.ViaVersionConfig;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.PlatformTask;
import com.viaversion.viaversion.api.platform.UnsupportedSoftware;
import com.viaversion.viaversion.api.platform.ViaPlatformTask;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.util.VersionInfo;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public interface ViaPlatform<T> {
    public Logger getLogger();

    default public Logger createLogger(String name) {
        return this.getLogger();
    }

    public String getPlatformName();

    public String getPlatformVersion();

    default public boolean isProxy() {
        return false;
    }

    default public String getPluginVersion() {
        return VersionInfo.getVersion();
    }

    default public PlatformTask runAsync(Runnable runnable) {
        return new ViaPlatformTask(Via.getManager().getScheduler().execute(runnable));
    }

    default public PlatformTask runRepeatingAsync(Runnable runnable, long ticks) {
        return new ViaPlatformTask(Via.getManager().getScheduler().scheduleRepeating(runnable, ticks * 50L, ticks * 50L, TimeUnit.MILLISECONDS));
    }

    default public PlatformTask runSync(Runnable runnable) {
        return this.runAsync(runnable);
    }

    default public PlatformTask runSync(Runnable runnable, long delay) {
        return new ViaPlatformTask(Via.getManager().getScheduler().schedule(runnable, delay * 50L, TimeUnit.MILLISECONDS));
    }

    default public PlatformTask runRepeatingSync(Runnable runnable, long period) {
        return this.runRepeatingAsync(runnable, period);
    }

    default public void sendMessage(UserConnection connection, String message) {
    }

    default public boolean kickPlayer(UserConnection connection, String message) {
        return false;
    }

    default public void sendCustomPayload(UserConnection connection, String channel, byte[] message) {
    }

    default public void sendCustomPayloadToClient(UserConnection connection, String channel, byte[] message) {
    }

    public ViaAPI<T> getApi();

    public ViaVersionConfig getConf();

    public File getDataFolder();

    default public void onReload() {
    }

    default public JsonObject getDump() {
        return new JsonObject();
    }

    default public Collection<UnsupportedSoftware> getUnsupportedSoftwareClasses() {
        return List.of();
    }

    default public boolean hasPlugin(String name) {
        return false;
    }

    default public boolean couldBeReloading() {
        return false;
    }
}

