/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.v1_21to1_21_2.rewriter;

import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectArrayMap;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.rewriter.RecipeRewriter1_20_3;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundPacket1_21;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RecipeRewriter1_21_2
extends RecipeRewriter1_20_3<ClientboundPacket1_21>
implements StorableObject {
    private static final int[] EMPTY_ARRAY = new int[0];
    private final List<StoneCutterRecipe> stoneCutterRecipes = new ArrayList<StoneCutterRecipe>();
    private final Object2IntMap<String> recipeGroups = new Object2IntOpenHashMap<String>();
    private final Map<String, Recipe> recipesByKey = new HashMap<String, Recipe>();
    private final Map<String, IntSet> recipeInputs = new Object2ObjectArrayMap<String, IntSet>();
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private String currentRecipeIdentifier;

    public void setCurrentRecipeIdentifier(String recipeIdentifier) {
        this.currentRecipeIdentifier = Key.stripMinecraftNamespace(recipeIdentifier);
    }

    RecipeRewriter1_21_2(Protocol<ClientboundPacket1_21, ?, ?, ?> protocol) {
        super(protocol);
        this.recipeGroups.defaultReturnValue(-1);
        this.recipeHandlers.put("smelting", wrapper -> this.handleSmelting("furnace_input", wrapper));
        this.recipeHandlers.put("blasting", wrapper -> this.handleSmelting("blast_furnace_input", wrapper));
        this.recipeHandlers.put("smoking", wrapper -> this.handleSmelting("smoker_input", wrapper));
        this.recipeHandlers.put("campfire_cooking", wrapper -> this.handleSmelting("campfire_input", wrapper));
    }

    @Override
    public void handleSimpleRecipe(PacketWrapper wrapper) {
        int category = wrapper.read(Types.VAR_INT);
    }

    @Override
    public void handleStonecutting(PacketWrapper wrapper) {
        int group = this.readRecipeGroup(wrapper);
        Item[] ingredient = this.readIngredient(wrapper);
        Item result = this.rewrite(wrapper.user(), wrapper.read(this.itemType()));
        StoneCutterRecipe recipe = new StoneCutterRecipe(this.currentRecipeIdentifier, group, ingredient, result);
        this.stoneCutterRecipes.add(recipe);
    }

    private void addRecipe(Recipe recipe) {
        this.recipes.add(recipe);
        this.recipesByKey.put(this.currentRecipeIdentifier, recipe);
    }

    @Override
    public void handleSmithingTransform(PacketWrapper wrapper) {
        this.readRecipeInputs("smithing_template", wrapper);
        this.readRecipeInputs("smithing_base", wrapper);
        this.readRecipeInputs("smithing_addition", wrapper);
        wrapper.read(this.itemType());
    }

    @Override
    public void handleSmithingTrim(PacketWrapper wrapper) {
        this.readRecipeInputs("smithing_template", wrapper);
        this.readRecipeInputs("smithing_base", wrapper);
        this.readRecipeInputs("smithing_addition", wrapper);
    }

    @Override
    public void handleCraftingShaped(PacketWrapper wrapper) {
        int group = this.readRecipeGroup(wrapper);
        int category = wrapper.read(Types.VAR_INT);
        int width = wrapper.read(Types.VAR_INT);
        int height = wrapper.read(Types.VAR_INT);
        int ingredientsSize = width * height;
        Item[][] ingredients = new Item[ingredientsSize][];
        for (int i = 0; i < ingredientsSize; ++i) {
            ingredients[i] = this.readIngredient(wrapper);
        }
        Item result = this.rewrite(wrapper.user(), wrapper.read(this.itemType()));
        boolean showNotification = wrapper.read(Types.BOOLEAN);
        ShapedRecipe recipe = new ShapedRecipe(this.recipesByKey.size(), this.currentRecipeIdentifier, group, category, width, height, ingredients, result, showNotification);
        this.addRecipe(recipe);
    }

    @Override
    public void handleCraftingShapeless(PacketWrapper wrapper) {
        int group = this.readRecipeGroup(wrapper);
        int category = wrapper.read(Types.VAR_INT);
        int ingredientsSize = wrapper.read(Types.VAR_INT);
        Item[][] ingredients = new Item[ingredientsSize][];
        for (int i = 0; i < ingredientsSize; ++i) {
            ingredients[i] = this.readIngredient(wrapper);
        }
        Item result = this.rewrite(wrapper.user(), wrapper.read(this.itemType()));
        ShapelessRecipe recipe = new ShapelessRecipe(this.recipesByKey.size(), this.currentRecipeIdentifier, group, category, ingredients, result);
        this.addRecipe(recipe);
    }

    public void handleSmelting(String key, PacketWrapper wrapper) {
        int group = this.readRecipeGroup(wrapper);
        int category = wrapper.read(Types.VAR_INT);
        Item[] ingredient = this.readRecipeInputs(key, wrapper);
        Item result = this.rewrite(wrapper.user(), wrapper.read(this.itemType()));
        float experience = wrapper.read(Types.FLOAT).floatValue();
        int cookingTime = wrapper.read(Types.VAR_INT);
        FurnaceRecipe recipe = new FurnaceRecipe(this.recipesByKey.size(), this.currentRecipeIdentifier, group, category, ingredient, result, cookingTime, experience);
        this.addRecipe(recipe);
    }

    private int readRecipeGroup(PacketWrapper wrapper) {
        String recipeGroup = Key.stripMinecraftNamespace(wrapper.read(Types.STRING));
        if (recipeGroup.isEmpty()) {
            return -1;
        }
        if (this.recipeGroups.containsKey(recipeGroup)) {
            return this.recipeGroups.getInt(recipeGroup);
        }
        int size = this.recipeGroups.size();
        this.recipeGroups.put(recipeGroup, size);
        return size;
    }

    private Item[] readIngredient(PacketWrapper wrapper) {
        Item[] items = wrapper.read(this.itemArrayType());
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            items[i] = this.rewrite(wrapper.user(), item);
        }
        return items;
    }

    public HolderSet toHolderSet(Item[] ingredient) {
        int[] ids = new int[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            ids[i] = ingredient[i].identifier();
        }
        return HolderSet.of(ids);
    }

    public @Nullable Recipe recipe(String key) {
        return this.recipesByKey.get(Key.stripMinecraftNamespace(key));
    }

    public @Nullable Recipe recipe(int displayId) {
        return displayId >= 0 && displayId < this.recipes.size() ? this.recipes.get(displayId) : null;
    }

    public void finalizeRecipes() {
        this.stoneCutterRecipes.sort(Comparator.comparing(recipe -> recipe.identifier));
    }

    public void writeUpdateRecipeInputs(PacketWrapper wrapper) {
        wrapper.write(Types.VAR_INT, this.recipeInputs.size());
        for (Map.Entry<String, IntSet> entry : this.recipeInputs.entrySet()) {
            wrapper.write(Types.STRING, entry.getKey());
            wrapper.write(Types.VAR_INT_ARRAY_PRIMITIVE, entry.getValue().toArray(EMPTY_ARRAY));
        }
        wrapper.write(Types.VAR_INT, this.stoneCutterRecipes.size());
        for (StoneCutterRecipe recipe : this.stoneCutterRecipes) {
            HolderSet ingredient = this.toHolderSet(recipe.ingredient());
            wrapper.write(Types.HOLDER_SET, ingredient);
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, recipe.result());
        }
    }

    private Item[] readRecipeInputs(String key, PacketWrapper wrapper) {
        Item[] ingredient = this.readIngredient(wrapper);
        IntSet ids = this.recipeInputs.computeIfAbsent(key, $ -> new IntOpenHashSet(ingredient.length));
        for (Item item : ingredient) {
            ids.add(item.identifier());
        }
        return ingredient;
    }

    private static void writeIngredientsDisplay(PacketWrapper wrapper, Item[][] ingredients) {
        wrapper.write(Types.VAR_INT, ingredients.length);
        for (Item[] ingredient : ingredients) {
            RecipeRewriter1_21_2.writeIngredientDisplay(wrapper, ingredient);
        }
    }

    private static void writeIngredientDisplay(PacketWrapper wrapper, Item[] ingredient) {
        if (ingredient.length == 0) {
            wrapper.write(Types.VAR_INT, 0);
            return;
        }
        if (ingredient.length == 1) {
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, ingredient[0]);
            return;
        }
        wrapper.write(Types.VAR_INT, 7);
        wrapper.write(Types.VAR_INT, ingredient.length);
        for (Item item : ingredient) {
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, item);
        }
    }

    private static void writeItemDisplay(PacketWrapper wrapper, Item item) {
        wrapper.write(Types.VAR_INT, 3);
        wrapper.write(VersionedTypes.V1_21_2.item, item.copy());
    }

    private static void writeCraftingStationDisplay(PacketWrapper wrapper) {
        wrapper.write(Types.VAR_INT, 0);
    }

    record StoneCutterRecipe(String identifier, int group, Item[] ingredient, Item result) {
        public int recipeDisplayId() {
            return 3;
        }

        public void writeRecipeDisplay(PacketWrapper wrapper) {
            RecipeRewriter1_21_2.writeIngredientDisplay(wrapper, this.ingredient);
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, this.result);
            RecipeRewriter1_21_2.writeCraftingStationDisplay(wrapper);
        }
    }

    record ShapedRecipe(int index, String identifier, int group, int category, int width, int height, Item[][] ingredients, Item result, boolean showNotification) implements Recipe
    {
        @Override
        public int recipeDisplayId() {
            return 1;
        }

        @Override
        public void writeRecipeDisplay(PacketWrapper wrapper) {
            wrapper.write(Types.VAR_INT, this.width);
            wrapper.write(Types.VAR_INT, this.height);
            RecipeRewriter1_21_2.writeIngredientsDisplay(wrapper, this.ingredients);
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, this.result);
            RecipeRewriter1_21_2.writeCraftingStationDisplay(wrapper);
        }
    }

    static interface Recipe {
        public static final int SLOT_DISPLAY_EMPTY = 0;
        public static final int SLOT_DISPLAY_ANY_FUEL = 1;
        public static final int SLOT_DISPLAY_ITEM = 3;
        public static final int SLOT_DISPLAY_COMPOSITE = 7;

        public int index();

        public String identifier();

        public int recipeDisplayId();

        default public Item @Nullable [][] ingredients() {
            Item[][] itemArrayArray;
            Item[] ingredient = this.ingredient();
            if (ingredient == null) {
                itemArrayArray = null;
            } else {
                Item[][] itemArrayArray2 = new Item[1][];
                itemArrayArray = itemArrayArray2;
                itemArrayArray2[0] = ingredient;
            }
            return itemArrayArray;
        }

        default public Item @Nullable [] ingredient() {
            return null;
        }

        default public int group() {
            return -1;
        }

        default public boolean showNotification() {
            return true;
        }

        public int category();

        public void writeRecipeDisplay(PacketWrapper var1);
    }

    record ShapelessRecipe(int index, String identifier, int group, int category, Item[][] ingredients, Item result) implements Recipe
    {
        @Override
        public int recipeDisplayId() {
            return 0;
        }

        @Override
        public void writeRecipeDisplay(PacketWrapper wrapper) {
            RecipeRewriter1_21_2.writeIngredientsDisplay(wrapper, this.ingredients);
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, this.result);
            RecipeRewriter1_21_2.writeCraftingStationDisplay(wrapper);
        }
    }

    record FurnaceRecipe(int index, String identifier, int group, int category, Item[] ingredient, Item result, int duration, float experience) implements Recipe
    {
        @Override
        public int recipeDisplayId() {
            return 2;
        }

        @Override
        public void writeRecipeDisplay(PacketWrapper wrapper) {
            RecipeRewriter1_21_2.writeIngredientDisplay(wrapper, this.ingredient);
            wrapper.write(Types.VAR_INT, 1);
            RecipeRewriter1_21_2.writeItemDisplay(wrapper, this.result);
            RecipeRewriter1_21_2.writeCraftingStationDisplay(wrapper);
            wrapper.write(Types.VAR_INT, this.duration);
            wrapper.write(Types.FLOAT, Float.valueOf(this.experience));
        }
    }
}

