/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.Driver;
import de.sormuras.junit.platform.isolator.Overlay;
import de.sormuras.junit.platform.isolator.OverlaySingleton;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;

public class Isolator {
    private static final Overlay overlay = OverlaySingleton.INSTANCE;
    private static final String WORKER_LOG_MESSAGE_PREFIX = "[WORKER] ";
    private final Driver driver;

    public Isolator(Driver driver) {
        this.driver = driver;
    }

    public int evaluate(Configuration configuration) throws ReflectiveOperationException {
        Set<String> selectedModules;
        Configuration.Basic basic = configuration.basic();
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        Path targetDirectory = Paths.get(basic.getTargetDirectory(), new String[0]);
        if (Files.isDirectory(targetDirectory, new LinkOption[0])) {
            List<String> lines = Arrays.asList(configuration.toString().split(" "));
            try {
                Files.write(targetDirectory.resolve("junit-platform-configuration.txt"), lines, new OpenOption[0]);
            }
            catch (IOException e) {
                this.driver.warn("Writing configuration failed", e.getMessage());
            }
        }
        ClassLoader loader = contextClassLoader;
        if (basic.isPlatformClassLoader()) {
            loader = overlay.platformClassLoader();
        }
        if ((selectedModules = configuration.discovery().getSelectedModules()).isEmpty()) {
            Map<String, Set<Path>> map = basic.toPaths();
            this.driver.debug("Building non-modular classloader stack: {0} layers", map.size());
            for (Map.Entry<String, Set<Path>> entry : map.entrySet()) {
                String name = entry.getKey();
                Set<Path> paths = entry.getValue();
                loader = overlay.newClassLoader(name, loader, paths);
                loader.setDefaultAssertionStatus(basic.isDefaultAssertionStatus());
                this.driver.debug("Created loader named {0} (parent={1}): {2}", name, loader, paths);
            }
        } else {
            this.driver.debug("Selected test module(s) present: " + selectedModules, new Object[0]);
            loader = overlay.newModuleLoader(this.driver, configuration, loader);
        }
        Class<?> workerClass = Class.forName(basic.getWorkerClassName(), true, loader);
        ClassLoader workerLoader = workerClass.getClassLoader();
        if (workerLoader != loader) {
            this.driver.warn("{0} was not loaded in isolation: {1}", workerClass, workerLoader);
            if (basic.isWorkerIsolationRequired()) {
                throw new IllegalStateException("Isolating worker failed!");
            }
        }
        Constructor<?> constructor = workerClass.getConstructor(byte[].class, BiConsumer.class);
        byte[] bytes = configuration.toBytes();
        BiConsumer<String, String> log = this::workerLogFunction;
        Callable worker = (Callable)constructor.newInstance(bytes, log);
        this.driver.debug("Instantiated {0}", worker);
        try {
            thread.setContextClassLoader(loader);
            int n = (Integer)worker.call();
            return n;
        }
        catch (Exception e) {
            this.driver.error("Calling worker failed: {0}", e.getMessage());
            throw new RuntimeException("Calling worker failed!", e);
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    private void workerLogFunction(String level, String message) {
        switch (level) {
            case "debug": {
                this.driver.debug(WORKER_LOG_MESSAGE_PREFIX + message, new Object[0]);
                return;
            }
            case "info": {
                this.driver.info(WORKER_LOG_MESSAGE_PREFIX + message, new Object[0]);
                return;
            }
            case "warn": {
                this.driver.warn(WORKER_LOG_MESSAGE_PREFIX + message, new Object[0]);
                return;
            }
            case "error": {
                this.driver.error(WORKER_LOG_MESSAGE_PREFIX + message, new Object[0]);
                return;
            }
        }
        this.driver.warn("[WORKER] [{0}] {1}", level, message);
    }
}

