/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.math;

import io.papermc.paper.math.BlockPositionImpl;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.FinePositionImpl;
import io.papermc.paper.math.Position;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface BlockPosition
extends Position {
    @Override
    default public double x() {
        return this.blockX();
    }

    @Override
    default public double y() {
        return this.blockY();
    }

    @Override
    default public double z() {
        return this.blockZ();
    }

    @Override
    default public boolean isBlock() {
        return true;
    }

    @Override
    default public boolean isFine() {
        return false;
    }

    @Override
    @NotNull
    default public BlockPosition toBlock() {
        return this;
    }

    @Override
    @NotNull
    default public BlockPosition offset(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPositionImpl(this.blockX() + x, this.blockY() + y, this.blockZ() + z);
    }

    @Override
    @NotNull
    default public FinePosition offset(double x, double y, double z) {
        return new FinePositionImpl((double)this.blockX() + z, (double)this.blockY() + y, (double)this.blockZ() + z);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public BlockPosition offset(@NotNull BlockFace blockFace) {
        return this.offset(blockFace, 1);
    }

    @Contract(pure=true)
    @NotNull
    default public BlockPosition offset(@NotNull BlockFace blockFace, int amount) {
        return amount == 0 ? this : new BlockPositionImpl(this.blockX() + blockFace.getModX() * amount, this.blockY() + blockFace.getModY() * amount, this.blockZ() + blockFace.getModZ() * amount);
    }

    @Contract(pure=true)
    @NotNull
    default public BlockPosition offset(@NotNull Axis axis, int amount) {
        BlockPosition blockPosition;
        if (amount == 0) {
            blockPosition = this;
        } else {
            switch (axis) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    blockPosition = new BlockPositionImpl(this.blockX() + amount, this.blockY(), this.blockZ());
                    break;
                }
                case Y: {
                    blockPosition = new BlockPositionImpl(this.blockX(), this.blockY() + amount, this.blockZ());
                    break;
                }
                case Z: {
                    blockPosition = new BlockPositionImpl(this.blockX(), this.blockY(), this.blockZ() + amount);
                }
            }
        }
        return blockPosition;
    }
}

