/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MusicInstrument
implements Keyed {
    private static final Map<NamespacedKey, MusicInstrument> INSTRUMENTS = new HashMap<NamespacedKey, MusicInstrument>();
    public static final MusicInstrument PONDER = MusicInstrument.getInstrument("ponder_goat_horn");
    public static final MusicInstrument SING = MusicInstrument.getInstrument("sing_goat_horn");
    public static final MusicInstrument SEEK = MusicInstrument.getInstrument("seek_goat_horn");
    public static final MusicInstrument FEEL = MusicInstrument.getInstrument("feel_goat_horn");
    public static final MusicInstrument ADMIRE = MusicInstrument.getInstrument("admire_goat_horn");
    public static final MusicInstrument CALL = MusicInstrument.getInstrument("call_goat_horn");
    public static final MusicInstrument YEARN = MusicInstrument.getInstrument("yearn_goat_horn");
    public static final MusicInstrument DREAM = MusicInstrument.getInstrument("dream_goat_horn");
    private final NamespacedKey key;

    private MusicInstrument(NamespacedKey key) {
        this.key = key;
        INSTRUMENTS.put(key, this);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Nullable
    public static MusicInstrument getByKey(@NotNull NamespacedKey namespacedKey) {
        Preconditions.checkArgument((namespacedKey != null ? 1 : 0) != 0, (Object)"NamespacedKey cannot be null");
        return INSTRUMENTS.get(namespacedKey);
    }

    @NotNull
    public static Collection<MusicInstrument> values() {
        return Collections.unmodifiableCollection(INSTRUMENTS.values());
    }

    private static MusicInstrument getInstrument(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Instrument name cannot be null");
        return new MusicInstrument(NamespacedKey.minecraft(name));
    }
}

