/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.internal.StringUtil;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.RakClientChannel;
import org.cloudburstmc.netty.channel.raknet.RakServerChannel;

public class RakChannelFactory<T extends Channel>
implements ChannelFactory<T> {
    private final Class<T> channelClass;
    private final Function<DatagramChannel, T> constructor;
    private final ChannelFactory<? extends DatagramChannel> datagramChannelFactory;
    private final Consumer<DatagramChannel> parentConsumer;

    private RakChannelFactory(Class<T> channelClass, Function<DatagramChannel, T> constructor, ChannelFactory<? extends DatagramChannel> datagramChannelFactory, Consumer<DatagramChannel> parentConsumer) {
        Objects.requireNonNull(channelClass, "channelClass");
        Objects.requireNonNull(datagramChannelFactory, "datagramChannelFactory");
        Objects.requireNonNull(constructor, "constructor");
        this.channelClass = channelClass;
        this.constructor = constructor;
        this.datagramChannelFactory = datagramChannelFactory;
        this.parentConsumer = parentConsumer;
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz) {
        return RakChannelFactory.server(clazz, null);
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer) {
        return RakChannelFactory.server(clazz, parentConsumer, null);
    }

    public static RakChannelFactory<RakServerChannel> server(Class<? extends DatagramChannel> clazz, Consumer<DatagramChannel> parentConsumer, Consumer<RakChannel> childConsumer) {
        return RakChannelFactory.server((ChannelFactory<? extends DatagramChannel>)new ReflectiveChannelFactory(clazz), parentConsumer, childConsumer);
    }

    public static RakChannelFactory<RakServerChannel> server(ChannelFactory<? extends DatagramChannel> channelFactory) {
        return RakChannelFactory.server(channelFactory, null);
    }

    public static RakChannelFactory<RakServerChannel> server(ChannelFactory<? extends DatagramChannel> channelFactory, Consumer<DatagramChannel> parentConsumer) {
        return RakChannelFactory.server(channelFactory, parentConsumer, null);
    }

    public static RakChannelFactory<RakServerChannel> server(ChannelFactory<? extends DatagramChannel> channelFactory, Consumer<DatagramChannel> parentConsumer, Consumer<RakChannel> childConsumer) {
        return new RakChannelFactory<RakServerChannel>(RakServerChannel.class, ch -> new RakServerChannel((DatagramChannel)ch, childConsumer), channelFactory, parentConsumer);
    }

    public static RakChannelFactory<RakClientChannel> client(Class<? extends DatagramChannel> clazz) {
        return RakChannelFactory.client(clazz, null);
    }

    public static RakChannelFactory<RakClientChannel> client(Class<? extends DatagramChannel> channelFactory, Consumer<DatagramChannel> parentConsumer) {
        return RakChannelFactory.client((ChannelFactory<? extends DatagramChannel>)new ReflectiveChannelFactory(channelFactory), parentConsumer);
    }

    public static RakChannelFactory<RakClientChannel> client(ChannelFactory<? extends DatagramChannel> channelFactory) {
        return RakChannelFactory.client(channelFactory, null);
    }

    public static RakChannelFactory<RakClientChannel> client(ChannelFactory<? extends DatagramChannel> channelFactory, Consumer<DatagramChannel> parentConsumer) {
        return new RakChannelFactory<RakClientChannel>(RakClientChannel.class, RakClientChannel::new, channelFactory, parentConsumer);
    }

    public T newChannel() {
        try {
            DatagramChannel channel = (DatagramChannel)this.datagramChannelFactory.newChannel();
            if (this.parentConsumer != null) {
                this.parentConsumer.accept(channel);
            }
            return (T)((Channel)this.constructor.apply(channel));
        }
        catch (Throwable t) {
            throw new ChannelException("Unable to create Channel from class " + this.channelClass, t);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(RakChannelFactory.class) + '(' + StringUtil.simpleClassName(this.channelClass) + ".class)";
    }
}

