/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.handler.codec.raknet.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Promise;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.RakPriority;
import org.cloudburstmc.netty.channel.raknet.RakReliability;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.netty.channel.raknet.packet.RakMessage;

public class RakClientNetworkSettingsHandler
extends ChannelOutboundHandlerAdapter {
    public static final String NAME = "rak-client-network-settings-handler";
    private final RakChannel channel;
    private final Promise<RakMessage> networkSettingsPacketPromise;

    public RakClientNetworkSettingsHandler(RakChannel channel, Promise<RakMessage> networkSettingsPacketPromise) {
        this.channel = channel;
        this.networkSettingsPacketPromise = networkSettingsPacketPromise;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        RakMessage packet;
        ctx.channel().pipeline().remove(NAME);
        if (!(msg instanceof RakMessage)) {
            if (!(msg instanceof ByteBuf)) throw new IllegalStateException("First packet was not an instance of RakMessage or ByteBuf: class " + msg.getClass().getName());
            packet = new RakMessage((ByteBuf)msg, RakReliability.RELIABLE_ORDERED, RakPriority.NORMAL);
        } else {
            packet = (RakMessage)((Object)msg);
        }
        ByteBuf content = packet.content();
        if (content.capacity() < 4) {
            throw new IllegalStateException("First packet was not a RequestNetworkSettings packet: Content less than 4 bytes");
        }
        if (content.getByte(0) != -2) {
            throw new IllegalStateException("First packet was not a RequestNetworkSettings packet: Expected RakNet game packet ID (254), but got " + content.getByte(0));
        }
        int rakVersion = (Integer)this.channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
        switch (rakVersion) {
            case 9: 
            case 10: 
            case 11: {
                if (content.getByte(1) != 6 || content.getByte(2) != -63 || (content.getByte(3) & 0xFFFFFF87) != 1) throw new IllegalStateException("First packet was not a RequestNetworkSettings packet: Invalid Bedrock packet ID");
                this.networkSettingsPacketPromise.setSuccess((Object)packet);
                return;
            }
            case 8: {
                if (content.getByte(1) != 7 || content.getByte(2) != -63) throw new IllegalStateException("First packet was not a RequestNetworkSettings packet: Invalid Bedrock packet ID");
                this.networkSettingsPacketPromise.setSuccess((Object)packet);
                return;
            }
            case 7: {
                if (content.getByte(1) != 5 || content.getByte(2) != -63) throw new IllegalStateException("First packet was not a RequestNetworkSettings packet: Invalid Bedrock packet ID");
                this.networkSettingsPacketPromise.setSuccess((Object)packet);
                return;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported protocol version: " + rakVersion);
            }
        }
    }
}

