/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.handler.codec.raknet.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Promise;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.RakOfflineState;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.netty.channel.raknet.packet.RakMessage;
import org.cloudburstmc.netty.handler.codec.raknet.client.RakClientNetworkSettingsHandler;
import org.cloudburstmc.netty.handler.codec.raknet.client.RakClientOfflineHandler;
import org.cloudburstmc.netty.handler.codec.raknet.client.RakClientOnlineInitialHandlerCompatible;
import org.cloudburstmc.netty.handler.codec.raknet.common.ConnectedPingHandler;
import org.cloudburstmc.netty.handler.codec.raknet.common.ConnectedPongHandler;
import org.cloudburstmc.netty.handler.codec.raknet.common.DisconnectNotificationHandler;
import org.cloudburstmc.netty.handler.codec.raknet.common.EncapsulatedToMessageHandler;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakAcknowledgeHandler;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakDatagramCodec;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodecCompatible;
import org.cloudburstmc.netty.util.RakUtils;

public class RakClientOfflineHandlerCompatible
extends RakClientOfflineHandler {
    public static final String NAME = "rak-client-handler";

    public RakClientOfflineHandlerCompatible(RakChannel rakChannel, ChannelPromise promise) {
        super(rakChannel, promise);
    }

    @Override
    void onRetryAttempt(Channel channel) {
        if (this.state() == RakOfflineState.HANDSHAKE_COMPLETED) {
            return;
        }
        this.sendOpenConnectionRequest1(channel);
        this.incrementConnectionAttempts();
    }

    @Override
    void onSuccess(ChannelHandlerContext ctx) {
        RakSessionCodecCompatible sessionCodec = new RakSessionCodecCompatible(this.rakChannel());
        Promise networkSettingsPacketPromise = ctx.executor().newPromise();
        ctx.pipeline().addAfter(NAME, "rak-datagram-codec", (ChannelHandler)new RakDatagramCodec());
        ctx.pipeline().addAfter("rak-datagram-codec", "rak-acknowledge-handler", (ChannelHandler)new RakAcknowledgeHandler(sessionCodec));
        ctx.pipeline().addAfter("rak-acknowledge-handler", "rak-session-codec", (ChannelHandler)sessionCodec);
        ctx.pipeline().addAfter("rak-session-codec", "rak-client-network-settings-handler", (ChannelHandler)new RakClientNetworkSettingsHandler(this.rakChannel(), (Promise<RakMessage>)networkSettingsPacketPromise));
        ctx.pipeline().addAfter("rak-session-codec", "rak-connected-ping-handler", (ChannelHandler)new ConnectedPingHandler());
        ctx.pipeline().addAfter("rak-connected-ping-handler", "rak-connected-pong-handler", (ChannelHandler)new ConnectedPongHandler(sessionCodec));
        ctx.pipeline().addAfter("rak-connected-pong-handler", "rak-disconnect-notification-handler", (ChannelHandler)DisconnectNotificationHandler.INSTANCE);
        ctx.pipeline().addAfter("rak-disconnect-notification-handler", "encapsulated-to-message", (ChannelHandler)EncapsulatedToMessageHandler.INSTANCE);
        ctx.pipeline().addAfter("rak-disconnect-notification-handler", "rak-client-online-initial-handler", (ChannelHandler)new RakClientOnlineInitialHandlerCompatible(this.rakChannel(), this.successPromise(), (Promise<RakMessage>)networkSettingsPacketPromise));
    }

    @Override
    void onOpenConnectionReply2(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.readLong();
        RakUtils.skipAddress(buffer);
        short mtu = buffer.readShort();
        buffer.skipBytes(1);
        this.rakChannel().config().setOption(RakChannelOption.RAK_MTU, mtu);
        this.state(RakOfflineState.HANDSHAKE_COMPLETED);
    }
}

