/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.handler.codec.raknet.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.cloudburstmc.netty.channel.raknet.RakClientChannel;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.netty.handler.codec.raknet.client.RakClientOfflineHandler;
import org.cloudburstmc.netty.handler.codec.raknet.client.RakClientOfflineHandlerCompatible;

public class RakClientRouteHandler
extends ChannelDuplexHandler {
    public static final String NAME = "rak-client-route-handler";
    private final RakClientChannel channel;

    public RakClientRouteHandler(RakClientChannel channel) {
        this.channel = channel;
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            promise.tryFailure((Throwable)new IllegalArgumentException("Provided remote address must be InetSocketAddress"));
            return;
        }
        if (this.channel.parent().isActive()) {
            throw new IllegalStateException("Channel is already bound!");
        }
        ChannelFuture parentFuture = this.channel.parent().connect(remoteAddress, localAddress);
        parentFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.channel.rakPipeline().addAfter("rak-unconnected-pong-deencoder", "rak-client-handler", (ChannelHandler)((Boolean)this.channel.config().getOption(RakChannelOption.RAK_COMPATIBILITY_MODE) != false ? new RakClientOfflineHandlerCompatible(this.channel, this.channel.getConnectPromise()) : new RakClientOfflineHandler(this.channel, this.channel.getConnectPromise())));
            }
        });
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)this.channel.eventLoop());
        combiner.add((Future)parentFuture);
        combiner.add((Future)this.channel.getConnectPromise());
        combiner.finish((Promise)promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
    }
}

