/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.util;

import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.ObjectPool;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.cloudburstmc.netty.util.RakUtils;

public class FastBinaryMinHeap<E>
extends AbstractReferenceCounted {
    private static final Entry INFIMUM = new Entry(Long.MAX_VALUE);
    private static final Entry SUPREMUM = new Entry(Long.MIN_VALUE);
    private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool(x$0 -> new Entry(x$0));
    private int size;
    private Entry[] heap;

    public FastBinaryMinHeap() {
        this(8);
    }

    public FastBinaryMinHeap(int initialCapacity) {
        this.heap = new Entry[++initialCapacity];
        Arrays.fill((Object[])this.heap, (Object)INFIMUM);
        this.heap[0] = SUPREMUM;
    }

    private static Entry newEntry(Object element, long weight) {
        Entry entry = (Entry)((Object)RECYCLER.get());
        entry.element = element;
        entry.weight = weight;
        return entry;
    }

    private void resize(int capacity) {
        int adjustedSize = this.size + 1;
        int copyLength = Math.min(this.heap.length, adjustedSize);
        Entry[] newHeap = new Entry[capacity];
        System.arraycopy(this.heap, 0, newHeap, 0, copyLength);
        if (capacity > adjustedSize) {
            Arrays.fill((Object[])newHeap, adjustedSize, capacity, (Object)INFIMUM);
        }
        this.heap = newHeap;
    }

    public void insert(long weight, E element) {
        Objects.requireNonNull(element, "element");
        this.ensureCapacity(this.size + 1);
        this.insert0(weight, element);
    }

    private void ensureCapacity(int size) {
        if (size + 1 >= this.heap.length) {
            this.resize(RakUtils.powerOfTwoCeiling(size + 1));
        }
    }

    public E peek() {
        Entry entry = this.heap[1];
        return (E)(entry != null ? entry.element : null);
    }

    private void insert0(long weight, E element) {
        int hole = ++this.size;
        int pred = hole >> 1;
        long predWeight = this.heap[pred].weight;
        while (predWeight > weight) {
            this.heap[hole] = this.heap[pred];
            hole = pred;
            predWeight = this.heap[pred >>= 1].weight;
        }
        this.heap[hole] = FastBinaryMinHeap.newEntry(element, weight);
    }

    public void insertSeries(long weight, E[] elements) {
        boolean optimized;
        Objects.requireNonNull(elements, "elements");
        if (elements.length == 0) {
            return;
        }
        this.ensureCapacity(this.size + elements.length);
        boolean bl = optimized = this.size == 0;
        if (!optimized) {
            optimized = true;
            int currentIdx = this.size;
            for (int parentIdx = 0; parentIdx < currentIdx; ++parentIdx) {
                if (weight >= this.heap[parentIdx].weight) continue;
                optimized = false;
                break;
            }
        }
        if (optimized) {
            for (E element : elements) {
                Objects.requireNonNull(element, "element");
                this.heap[++this.size] = FastBinaryMinHeap.newEntry(element, weight);
            }
        } else {
            for (E element : elements) {
                Objects.requireNonNull(element, "element");
                this.insert0(weight, element);
            }
        }
    }

    public E poll() {
        if (this.size > 0) {
            Object e = this.heap[1].element;
            this.remove();
            return (E)e;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void remove() {
        if (this.size == 0) {
            throw new NoSuchElementException("Heap is empty");
        }
        this.heap[1].release();
        int hole = 1;
        int sz = this.size;
        for (int succ = 2; succ < sz; succ <<= 1) {
            Entry entry1 = this.heap[succ];
            Entry entry2 = this.heap[succ + 1];
            this.heap[hole] = entry1.weight > entry2.weight ? entry2 : entry1;
            hole = ++succ;
        }
        Entry bubble = this.heap[sz];
        int pred = hole >> 1;
        while (this.heap[pred].weight > bubble.weight) {
            this.heap[hole] = this.heap[pred];
            hole = pred;
            pred >>= 1;
        }
        this.heap[hole] = bubble;
        this.heap[sz] = INFIMUM;
        --this.size;
        if (this.size << 2 < this.heap.length && this.size > 4) {
            this.resize(this.size << 1);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void deallocate() {
        while (this.size > 0) {
            Entry entry = this.heap[1];
            this.remove();
            entry.release();
        }
    }

    public FastBinaryMinHeap<E> touch(Object hint) {
        return this;
    }

    private static class Entry
    extends AbstractReferenceCounted {
        private final ObjectPool.Handle<Entry> handle;
        private Object element;
        private long weight;

        private Entry(long weight) {
            this.weight = weight;
            this.handle = null;
        }

        private Entry(ObjectPool.Handle<Entry> handle) {
            this.handle = handle;
        }

        protected void deallocate() {
            this.setRefCnt(1);
            if (this.handle == null) {
                return;
            }
            this.element = null;
            this.weight = 0L;
            this.handle.recycle((Object)this);
        }

        public Entry touch(Object hint) {
            return this;
        }
    }
}

