/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.mobs;

import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.DespawnMode;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.core.skills.SkillMechanic;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;

public interface MythicMob
extends Comparable<MythicMob> {
    public String getInternalName();

    public String getFile();

    public PlaceholderString getDisplayName();

    public String getEntityType();

    public BukkitEntityType getMythicEntity();

    public DespawnMode getDespawnMode();

    public String getEggDisplay();

    public MobModel getModel();

    public DropTable getDropTable();

    public DropTable getEquipmentTable();

    public Boolean getOptionLockPitch();

    public Map<String, Double> getDamageModifiers();

    public Map<String, Double> getEntityDamageModifiers();

    public String getAiNavigator();

    public boolean isUsingTimers();

    public int getNoDamageTicks();

    public int getMaxAttackRange();

    public int getMaxAttackableRange();

    public int getMaxThreatDistance();

    public boolean isUseCustomNameplate();

    public Boolean getRepeatAllSkills();

    public Boolean getPreventOtherDrops();

    public Boolean getPreventRandomEquipment();

    public Boolean getPreventLeashing();

    public Boolean getPreventRename();

    public Boolean getPreventSlimeSplit();

    public Boolean getPreventEndermanTeleport();

    public Boolean getPreventItemPickup();

    public Boolean getPreventSilverfishInfection();

    public Boolean getPreventSunburn();

    public Boolean getPreventExploding();

    public Boolean getPreventMobKillDrops();

    public Boolean getPreventTransformation();

    public Boolean getPreventJockeyMounts();

    public Boolean getPassthroughDamage();

    public Boolean getApplyInvisibility();

    public Boolean getDigOutOfGround();

    public Boolean getUsesHealthBar();

    public double getSpawnVelocityX();

    public double getSpawnVelocityXMax();

    public double getSpawnVelocityY();

    public double getSpawnVelocityYMax();

    public double getSpawnVelocityZ();

    public double getSpawnVelocityZMax();

    public Boolean getSpawnVelocityXRange();

    public Boolean getSpawnVelocityYRange();

    public Boolean getSpawnVelocityZRange();

    public String getDisguise();

    public boolean isFakePlayer();

    public MythicConfig getConfig();

    default public ActiveMob spawn(AbstractLocation location, double level) {
        return this.spawn(location, level, SpawnReason.OTHER);
    }

    public ActiveMob spawn(AbstractLocation var1, double var2, SpawnReason var4);

    public ActiveMob spawn(AbstractLocation var1, double var2, SpawnReason var4, Consumer<Entity> var5);

    public ActiveMob applyMobOptions(ActiveMob var1, double var2);

    public ActiveMob applyMobVolatileOptions(ActiveMob var1);

    public ActiveMob applySpawnModifiers(ActiveMob var1);

    public void executeSkills(SkillTrigger var1, SkillMetadata var2);

    public void executeSignalSkill(String var1, SkillMetadata var2);

    public Queue<SkillMechanic> getSkills(SkillTrigger var1);

    public boolean hasSkills(SkillTrigger var1);

    public Queue<SkillMechanic> getTimerSkills();

    public double getPerLevelHealth();

    public double getPerLevelDamage();

    public double getPerLevelPower();

    public PlaceholderDouble getArmor();

    public double getPerLevelArmor();

    public double getArmor(ActiveMob var1);

    public PlaceholderDouble getDamage();

    public double getDamage(ActiveMob var1);

    public double getMovementSpeed(ActiveMob var1);

    public double getKnockbackResistance(double var1);

    public double getAttackSpeed(double var1);

    public boolean hasFaction();

    public String getFaction();

    public PlaceholderDouble getHealth();

    public double getHealth(ActiveMob var1);

    public boolean getIsInvincible();

    public boolean usesThreatTable();

    public boolean usesImmunityTable();

    public boolean getThreatTableUseDamageTaken();

    public boolean getThreatTableDecaysUnreachable();

    public List<String> getLevelModifiers();

    public List<String> getAIGoalSelectors();

    public List<String> getAITargetSelectors();

    public boolean hasKillMessages();

    public PlaceholderString getKillMessage();

    public boolean getIsInteractable();

    public boolean usesBossBar();

    public int getBossBarRangeSquared();

    public Optional<AbstractBossBar> getBossBar();

    public PlaceholderString getBossBarTitle();

    public boolean getShowHealthInChat();

    public boolean getShowNameOnDamaged();
}

