/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.adapters.BukkitEntity;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPlayer;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public final class BukkitAdapter {
    public static AbstractEntity adapt(Entity entity) {
        if (entity == null) {
            return null;
        }
        return new BukkitEntity(entity);
    }

    public static Entity adapt(AbstractEntity entity) {
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public static AbstractPlayer adapt(Player player) {
        if (player == null) {
            return null;
        }
        return new BukkitPlayer(player);
    }

    public static ItemStack adapt(AbstractItemStack item) {
        if (item == null) {
            return null;
        }
        return ((BukkitItemStack)item).build();
    }

    public static AbstractItemStack adapt(ItemStack item) {
        if (item == null) {
            return null;
        }
        return new BukkitItemStack(item);
    }

    public static Player adapt(AbstractPlayer player) {
        if (player == null) {
            return null;
        }
        return (Player)player.getBukkitEntity();
    }

    public static AbstractWorld adapt(World world) {
        return new BukkitWorld(world);
    }

    public static World adapt(AbstractWorld world) {
        if (world instanceof BukkitWorld) {
            return ((BukkitWorld)world).getBukkitWorld();
        }
        World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + world);
    }

    public static AbstractLocation adapt(Location location) {
        if (location == null) {
            return null;
        }
        return new AbstractLocation(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Location adapt(AbstractLocation location) {
        return new Location(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static AbstractVector adapt(Vector vector) {
        if (vector == null) {
            return null;
        }
        return new AbstractVector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector adapt(AbstractVector vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    @Deprecated
    public static AbstractBiome adapt(Biome b) {
        if (b == null) {
            return null;
        }
        return new AbstractBiome(b.toString());
    }
}

