/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractFirework;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.adapters.ServerInterface;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitFirework;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import io.lumine.mythic.bukkit.adapters.bossbars.AdventureBossBar;
import io.lumine.mythic.bukkit.entities.BukkitBabyPigZombie;
import io.lumine.mythic.bukkit.entities.BukkitBabyPigZombieVillager;
import io.lumine.mythic.bukkit.entities.BukkitBabyZombie;
import io.lumine.mythic.bukkit.entities.BukkitBabyZombieVillager;
import io.lumine.mythic.bukkit.entities.BukkitElderGuardian;
import io.lumine.mythic.bukkit.entities.BukkitPigZombie;
import io.lumine.mythic.bukkit.entities.BukkitPigZombieVillager;
import io.lumine.mythic.bukkit.entities.BukkitWitherSkeleton;
import io.lumine.mythic.bukkit.entities.BukkitZombie;
import io.lumine.mythic.bukkit.entities.BukkitZombieVillager;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.listeners.ChunkListeners;
import io.lumine.mythic.bukkit.listeners.MobListeners;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.utils.Events;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.plugin.ReloadableModule;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class BukkitBootstrap
extends ReloadableModule<MythicBukkit>
implements ServerInterface {
    private MobListeners mobListeners;
    private ChunkListeners chunkListeners;

    public BukkitBootstrap(MythicBukkit plugin) {
        super(plugin);
        Events.subscribe(WorldLoadEvent.class, EventPriority.MONITOR).handler(event -> plugin.getVolatileCodeHandler().getWorldHandler().registerWorldAccess(event.getWorld())).bindWith(this);
        Events.subscribe(WorldUnloadEvent.class, EventPriority.MONITOR).handler(event -> plugin.getVolatileCodeHandler().getWorldHandler().unregisterWorldAccess(event.getWorld())).bindWith(this);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.mobListeners = new MobListeners(plugin);
        this.bind(this.mobListeners);
        this.chunkListeners = new ChunkListeners(plugin);
        this.bind(this.chunkListeners);
    }

    @Override
    public void unload() {
    }

    @Override
    public List<AbstractWorld> getWorlds() {
        ArrayList<AbstractWorld> wl = new ArrayList<AbstractWorld>();
        for (World w : Bukkit.getWorlds()) {
            wl.add(new BukkitWorld(w));
        }
        return wl;
    }

    @Override
    public void dispatchCommand(String s2) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), s2);
    }

    @Override
    public AbstractPlayer getPlayer(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return BukkitAdapter.adapt(player);
    }

    @Override
    public AbstractPlayer getPlayer(String name) {
        Player player = Bukkit.getPlayerExact((String)name);
        if (player == null) {
            return null;
        }
        return BukkitAdapter.adapt(player);
    }

    @Override
    public AbstractEntity getEntity(UUID uuid) {
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity == null) {
            return null;
        }
        return BukkitAdapter.adapt(entity);
    }

    @Override
    public AbstractWorld getWorld(UUID uuid) {
        World world = Bukkit.getWorld((UUID)uuid);
        if (world == null) {
            return null;
        }
        return BukkitAdapter.adapt(world);
    }

    @Override
    public AbstractWorld getWorld(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            return null;
        }
        return new BukkitWorld(world);
    }

    @Override
    public List<AbstractPlayer> getOnlinePlayers() {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z, float yaw, float pitch) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z, yaw, pitch);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public boolean isValidBiome(Object o) {
        return false;
    }

    @Override
    public AbstractBossBar createBossBar(String title, AbstractBossBar.BarColor color, AbstractBossBar.BarStyle style) {
        return new AdventureBossBar(title, 1.0f, color, style);
    }

    @Override
    public MythicEntityType getMythicEntityType(Entity e) {
        return MythicEntityType.get(switch (type = e.getType().toString()) {
            case "GUARDIAN" -> {
                if (!BukkitElderGuardian.isInstanceOf(e)) yield "ELDER_GUARDIAN";
            }
            case "PIG_ZOMBIE" -> {
                if (BukkitPigZombie.isInstanceOf(e)) if (BukkitBabyPigZombie.isInstanceOf(e)) {
                    yield "BABY_PIG_ZOMBIE";
                }
                if (BukkitPigZombieVillager.isInstanceOf(e)) {
                    yield "PIG_ZOMBIE_VILLAGER";
                }
                if (!BukkitBabyPigZombieVillager.isInstanceOf(e)) yield "BABY_PIG_ZOMBIE_VILLAGER";
            }
            case "SKELETON" -> {
                if (!BukkitWitherSkeleton.isInstanceOf(e)) yield "WITHER_SKELETON";
            }
            case "ZOMBIE" -> {
                if (BukkitZombie.isInstanceOf(e)) if (BukkitBabyZombie.isInstanceOf(e)) {
                    yield "BABY_ZOMBIE";
                }
                if (BukkitZombieVillager.isInstanceOf(e)) {
                    yield "ZOMBIE_VILLAGER";
                }
                if (!BukkitBabyZombieVillager.isInstanceOf(e)) yield "BABY_ZOMBIE_VILLAGER";
            }
        });
    }

    @Override
    public void handleMobDespawnEvent(ActiveMob mob) {
        Schedulers.sync().run(() -> {
            MythicMobDespawnEvent mythicDespawnEvent = new MythicMobDespawnEvent(mob);
            Events.call(mythicDespawnEvent);
        });
    }

    @Override
    public AbstractFirework createFirework(String type, int duration, Collection<Color> colors, Collection<Color> fadeColors, boolean flicker, boolean trail) {
        return new BukkitFirework(type, duration, colors, fadeColors, flicker, trail);
    }
}

