/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.adapters.ServerInterface;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.adapters.TaskManager;
import io.lumine.mythic.api.volatilecode.VolatileCodeDisabled;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.bukkit.BukkitAPIHelper;
import io.lumine.mythic.bukkit.BukkitBootstrap;
import io.lumine.mythic.bukkit.adapters.BukkitSkillTriggers;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import io.lumine.mythic.bukkit.clock.MythicClock;
import io.lumine.mythic.bukkit.clock.TimingsHandler;
import io.lumine.mythic.bukkit.commands.BaseCommand;
import io.lumine.mythic.bukkit.commands.mobs.SpawnCommand;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.listeners.EggListeners;
import io.lumine.mythic.bukkit.listeners.PlayerListeners;
import io.lumine.mythic.bukkit.listeners.ThreatTableListeners;
import io.lumine.mythic.bukkit.metrics.MetricsLite;
import io.lumine.mythic.bukkit.metrics.bStats;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.drops.DropExecutor;
import io.lumine.mythic.core.holograms.HologramManager;
import io.lumine.mythic.core.items.ItemExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.mobs.EntityManager;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.players.PlayerManager;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableManager;
import io.lumine.mythic.core.skills.variables.VariableSerializer;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.spawners.SpawnerManager;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.NBTCompoundSerializer;
import io.lumine.mythic.core.utils.jnbt.NBTSerializer;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.worlds.WorldManager;
import io.lumine.mythic.utils.chat.ColorString;
import io.lumine.mythic.utils.gson.GsonProvider;
import io.lumine.mythic.utils.holograms.BukkitHologramFactory;
import io.lumine.mythic.utils.holograms.HologramFactory;
import io.lumine.mythic.utils.logging.ConsoleColor;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.version.ServerVersion;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class MythicBukkit
extends LuminePlugin
implements MythicPlugin {
    private static MythicBukkit plugin;
    private ServerInterface server;
    private BaseCommand baseCommand;
    private ConfigManager configuration;
    private MythicClock clock;
    private EntityManager entityManager;
    private RandomSpawnerManager randomSpawningManager;
    private MobExecutor mobManager;
    private PlayerManager playerManager;
    private WorldManager worldManager;
    private SkillExecutor skillManager;
    private DropExecutor dropManager;
    private ItemExecutor itemManager;
    private SpawnerManager spawnerManager;
    private VariableManager variableManager;
    private MenuManager menuManager;
    private PlaceholderExecutor placeholderManager;
    private HologramManager hologramManager;
    private CompatibilityManager compatibility;
    private BukkitHologramFactory hologramProvider;
    private VolatileCodeHandler volatileCodeHandler;
    private TimingsHandler timingsHandler;
    private BukkitAPIHelper APIHelper;
    private Boolean isUpdateAvailable = false;
    private static boolean p;
    private static final Object volatilityHandler;

    @Override
    public void load() {
        plugin = this;
    }

    @Override
    public void enable() {
        this.server = new BukkitBootstrap(this);
        TaskManager.initializeBukkit(this);
        SkillAdapter.initializeBukkit();
        MythicLogger.log("Loading {0} for {1} {2}...", this.getDescription().getName(), ServerVersion.isPaper() ? "Paper" : "Spigot", ServerVersion.get().toString());
        if (ServerVersion.isPaper()) {
            MythicLogger.log("The server is running PaperSpigot; enabled PaperSpigot exclusive functionality");
        } else {
            MythicLogger.log("The server is running Spigot; disabled PaperSpigot exclusive functionality");
        }
        Patterns.CompilePatterns();
        GsonProvider.update(builder -> builder.registerTypeAdapter(AbstractWorld.class, (Object)GsonProvider.standard().getAdapter(BukkitWorld.class)).registerTypeAdapter(Tag.class, (Object)new NBTSerializer()).registerTypeAdapter(CompoundTag.class, (Object)new NBTCompoundSerializer()).registerTypeAdapter(Variable.class, (Object)new VariableSerializer()));
        this.configuration = new ConfigManager(this);
        this.bind(this.configuration);
        this.hologramProvider = new BukkitHologramFactory();
        this.provideService(HologramFactory.class, this.hologramProvider);
        this.volatileCodeHandler = this.getVolatileCodeHandler();
        this.compatibility = new CompatibilityManager(this);
        this.itemManager = new ItemExecutor(this);
        this.dropManager = new DropExecutor(this);
        this.mobManager = new MobExecutor(this);
        this.playerManager = new PlayerManager(this);
        this.worldManager = new WorldManager(this);
        this.skillManager = new SkillExecutor(this);
        this.spawnerManager = new SpawnerManager(this);
        this.randomSpawningManager = new RandomSpawnerManager(this);
        this.variableManager = new VariableManager(this);
        this.menuManager = new MenuManager(this);
        this.placeholderManager = new PlaceholderExecutor(this);
        this.hologramManager = new HologramManager(this, this.compatibility);
        this.getConfiguration().load(this);
        MythicLogger.log("MythicMobs configuration file loaded successfully.");
        this.timingsHandler = new TimingsHandler();
        this.entityManager = new EntityManager();
        this.clock = new MythicClock(this);
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)this.entityManager, (Plugin)this);
        manager.registerEvents((Listener)new BukkitSkillTriggers(this), (Plugin)this);
        manager.registerEvents((Listener)new ThreatTableListeners(), (Plugin)this);
        manager.registerEvents((Listener)new EggListeners(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.APIHelper = new BukkitAPIHelper();
        this.baseCommand = new BaseCommand(this);
        this.registerCommand("mythicmobs", this.baseCommand);
        this.registerCommand("spawnmob", new SpawnCommand(this));
        MythicProvider.register(this);
        if (ConfigManager.AllowMetrics) {
            new bStats(this);
            try {
                new MetricsLite(this);
            }
            catch (IOException e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MetricsLite: Failed to submit MetricsLite stats.", new Object[0]);
            }
        }
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + " MythicMobs" + (MythicBukkit.isVolatile() ? " Premium" : "") + " v" + this.getVersion() + " (build " + this.getBuildNumber() + ") has been successfully loaded!" + ConsoleColor.RESET);
        MythicBukkit.inst().getMobManager().ScanWorld();
    }

    @Override
    public void disable() {
        MythicLogger.log("Disabling Mythic Mobs...");
        this.getSpawnerManager().resetAndSaveAll();
        this.configuration.save();
        this.getMobManager().despawnAllMobs();
        this.entityManager = null;
        this.volatileCodeHandler = null;
        this.timingsHandler = null;
        MythicLogger.log("All active settings have been saved.");
        this.configuration.unload();
        this.compatibility.terminate();
    }

    public static MythicBukkit inst() {
        return plugin;
    }

    public static final boolean p() {
        return p;
    }

    public ServerInterface getBootstrap() {
        return this.server;
    }

    @Override
    public VolatileCodeHandler getVolatileCodeHandler() {
        if (this.volatileCodeHandler != null) {
            return this.volatileCodeHandler;
        }
        VolatileCodeHandler VCH = new VolatileCodeDisabled();
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (version.equals("craftbukkit")) {
            version = "pre";
        }
        try {
            Class<?> clazz = Class.forName("io.lumine.mythic.core.volatilecode.VolatileCodeEnabled_" + version);
            if (VolatileCodeHandler.class.isAssignableFrom(clazz)) {
                VCH = (VolatileCodeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            MythicLogger.error(ColorString.get("&6--====|||| &c&lMythicMobs &6||||====--"));
            MythicLogger.error("This version of MythicMobs is not fully compatible with your version of Bukkit.");
            MythicLogger.error("Some features may be limited or disabled until you use a compatible version.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. Volatile code has been disabled.", e);
        }
        this.volatileCodeHandler = VCH;
        return VCH;
    }

    public static final boolean isVolatile() {
        return volatilityHandler == null;
    }

    public String getVersion() {
        return this.getDescription().getVersion().split("-")[0];
    }

    public String getBuildNumber() {
        String[] split = this.getDescription().getVersion().split("-");
        if (split.length == 2) {
            return split[1];
        }
        if (split.length == 3) {
            return split[2];
        }
        return "????";
    }

    public BaseCommand getBaseCommand() {
        return this.baseCommand;
    }

    public ConfigManager getConfiguration() {
        return this.configuration;
    }

    public MythicClock getClock() {
        return this.clock;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public RandomSpawnerManager getRandomSpawningManager() {
        return this.randomSpawningManager;
    }

    @Override
    public MobExecutor getMobManager() {
        return this.mobManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    @Override
    public SkillExecutor getSkillManager() {
        return this.skillManager;
    }

    @Override
    public DropExecutor getDropManager() {
        return this.dropManager;
    }

    @Override
    public ItemExecutor getItemManager() {
        return this.itemManager;
    }

    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    public PlaceholderExecutor getPlaceholderManager() {
        return this.placeholderManager;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public CompatibilityManager getCompatibility() {
        return this.compatibility;
    }

    public BukkitHologramFactory getHologramProvider() {
        return this.hologramProvider;
    }

    public TimingsHandler getTimingsHandler() {
        return this.timingsHandler;
    }

    public BukkitAPIHelper getAPIHelper() {
        return this.APIHelper;
    }

    public Boolean getIsUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    static {
        p = false;
        volatilityHandler = new Object();
    }
}

