/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.BukkitAdapter;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;

public class BukkitBlock
extends AbstractBlock {
    private final Material material;

    public BukkitBlock(String type) {
        this.material = Material.valueOf((String)type.toUpperCase());
    }

    public BukkitBlock(Material material) {
        this.material = material;
    }

    @Override
    public void set(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        l.getBlock().setType(this.material);
    }

    @Override
    public void set(AbstractLocation location, int age, Bisected.Half bisectedHalf, BlockFace blockFace, Axis axis, Slab.Type slabType, boolean waterLogged, FaceAttachable.AttachedFace attachedFace, Stairs.Shape stairshape) {
        Location l = BukkitAdapter.adapt(location);
        Block block = l.getBlock();
        block.setType(this.material);
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            ((Ageable)blockData).setAge(Math.min(age, ((Ageable)blockData).getMaximumAge()));
        }
        if (blockData instanceof Sapling) {
            ((Sapling)blockData).setStage(Math.min(age, ((Sapling)blockData).getMaximumStage()));
        }
        if (blockData instanceof Bisected) {
            ((Bisected)blockData).setHalf(bisectedHalf);
        }
        if (blockData instanceof Directional) {
            ((Directional)blockData).setFacing(blockFace);
        }
        if (blockData instanceof Orientable) {
            ((Orientable)blockData).setAxis(axis);
        }
        if (blockData instanceof Rotatable) {
            ((Rotatable)blockData).setRotation(blockFace);
        }
        if (blockData instanceof Waterlogged) {
            ((Waterlogged)blockData).setWaterlogged(waterLogged);
        }
        if (blockData instanceof Slab) {
            ((Slab)blockData).setType(slabType);
        }
        if (blockData instanceof FaceAttachable) {
            ((FaceAttachable)blockData).setAttachedFace(attachedFace);
        }
        block.setBlockData(blockData);
    }
}

