/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import java.util.Optional;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;

public class BukkitTriggerMetadata {
    public static SkillMetadata apply(SkillMetadata meta, EntityDamageEvent event) {
        AbstractEntity damaged = BukkitAdapter.adapt(event.getEntity());
        Optional<Object> maybeData = damaged.getMetadata("skill-damage");
        meta.getVariables().putString("damage-amount", String.valueOf(event.getFinalDamage()));
        if (maybeData.isPresent()) {
            DamageMetadata data = (DamageMetadata)maybeData.get();
            meta.getVariables().putObject("damage-metadata", data);
            meta.getVariables().putString("damage-cause", "SKILL");
            meta.getVariables().putString("real-damage-cause", event.getCause().toString());
            meta.getVariables().putString("damage-type", data.getElement() == null ? "SKILL" : data.getElement());
        } else {
            meta.getVariables().putString("damage-cause", event.getCause().toString());
        }
        return meta;
    }

    public static SkillMetadata apply(SkillMetadata meta, EntityShootBowEvent event) {
        meta.getVariables().putObject("shot-projectile", event.getEntity());
        return meta;
    }

    public static SkillMetadata apply(SkillMetadata meta, ProjectileLaunchEvent event) {
        meta.getVariables().putObject("shot-projectile", event.getEntity());
        return meta;
    }

    public static void apply(SkillMetadata meta, BlockBreakEvent event) {
    }

    public static void apply(SkillMetadata meta, BlockPlaceEvent event) {
    }
}

