/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.clock;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.plugin.ReloadableModule;
import io.lumine.mythic.utils.tasks.Task;

public class MythicClock
extends ReloadableModule<MythicBukkit> {
    private Task syncClock;
    private Task savingClock;
    private Task spawningClock;
    private Task skillClock;
    private Task threatClock;
    private int ticker;
    private long skillClockIteration = 0L;

    public MythicClock(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.syncClock = Schedulers.sync().runRepeating(this::runSyncClock, 0L, (long)ConfigManager.ClockInterval);
        this.savingClock = Schedulers.sync().runRepeating(this::runSavingClock, 0L, (long)(ConfigManager.SaveInteval * 20));
        this.spawningClock = Schedulers.sync().runRepeating(this::runSpawningClock, 0L, (long)(ConfigManager.SpawningInterval * 20));
        if (ConfigManager.EnableThreatTables) {
            this.threatClock = Schedulers.sync().runRepeating(this::runThreatClock, 0L, 20L);
        }
        if (ConfigManager.EnableTimerSkills) {
            this.skillClock = Schedulers.async().runRepeating(this::runSkillClock, 0L, (long)ConfigManager.ClockInterval);
        }
    }

    @Override
    public void unload() {
        if (this.syncClock != null) {
            this.syncClock.terminate();
        }
        if (this.savingClock != null) {
            this.savingClock.terminate();
        }
        if (this.skillClock != null) {
            this.skillClock.terminate();
        }
        if (this.spawningClock != null) {
            this.spawningClock.terminate();
        }
        if (this.threatClock != null) {
            this.threatClock.terminate();
        }
    }

    public void runSyncClock() {
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Main clock fired", new Object[0]);
        this.ticker += ConfigManager.ClockInterval;
        AbstractSkill.cooldownTimer += (long)ConfigManager.ClockInterval;
        if (this.ticker > 20) {
            ((MythicBukkit)this.getPlugin()).getEntityManager().refreshCaches();
            this.ticker = 0;
        }
    }

    public void runSavingClock() {
        this.executeSave();
    }

    public void runSkillClock() {
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Skill clock fired", new Object[0]);
        ++this.skillClockIteration;
        ((MythicBukkit)this.getPlugin()).getSkillManager().runTimerSkills(this.skillClockIteration);
    }

    public void runSpawningClock() {
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Spawner clock fired", new Object[0]);
        if (!ConfigManager.debugSpawners) {
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markRandomSpawnersNew();
            ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().spawnMobs();
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markRandomSpawnersComplete();
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSpawnersNew();
            ((MythicBukkit)this.getPlugin()).getSpawnerManager().tickSpawnerClocks();
            ((MythicBukkit)this.getPlugin()).getTimingsHandler().markSpawnersComplete();
        }
    }

    public void runThreatClock() {
        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Threat clock fired", new Object[0]);
        ((MythicBukkit)this.getPlugin()).getTimingsHandler().markThreatTablesNew();
        ((MythicBukkit)this.getPlugin()).getMobManager().getMobsInCombat().forEach(am -> am.getThreatTable().tickThreat());
        ((MythicBukkit)this.getPlugin()).getTimingsHandler().markThreatTablesComplete();
    }

    public void runCleanupClock() {
    }

    private void executeSave() {
        ((MythicBukkit)this.getPlugin()).getConfiguration().save();
    }
}

