/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.events.MythicReloadedEvent;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.commands.Command;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

public class ReloadCommand
extends Command<MythicBukkit> {
    boolean reloading = false;

    public ReloadCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (this.reloading) {
            CommandHelper.sendError(sender, "Plugin is already reloading...");
            return true;
        }
        boolean optSync = true;
        if (args != null && args.length > 0 && args[0].startsWith("-")) {
            if (args[0].startsWith("-a")) {
                optSync = false;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        CommandHelper.sendSuccess(sender, "Reloading plugin...");
        MythicLogger.log("Mythic beginning reload procedure...");
        this.reloading = true;
        ((MythicBukkit)this.getPlugin()).getClock().unload();
        if (optSync) {
            this.doReloadPart1(sender);
            this.doReloadPart2(sender);
        } else {
            Schedulers.async().run(() -> {
                this.doReloadPart1(sender);
                Schedulers.sync().run(() -> this.doReloadPart2(sender));
            });
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.reload";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"r", "re"};
    }

    private void doReloadPart1(CommandSender sender) {
        try {
            ((MythicBukkit)this.getPlugin()).getConfiguration().save();
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        try {
            ((MythicBukkit)this.plugin).getPlaceholderManager().reload();
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        try {
            ((MythicBukkit)this.plugin).getSpawnerManager().resetAndSaveAll();
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        try {
            ((MythicBukkit)this.plugin).getConfiguration().reload();
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        try {
            ((MythicBukkit)this.plugin).getRandomSpawningManager().reload();
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
    }

    private void doReloadPart2(CommandSender sender) {
        try {
            for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
                am.remountSpawner();
                am.remountType();
            }
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        ((MythicBukkit)this.getPlugin()).getClock().load((MythicBukkit)this.getPlugin());
        this.reloading = false;
        try {
            MythicReloadedEvent event = new MythicReloadedEvent((MythicBukkit)this.plugin);
            ((MythicBukkit)this.plugin).getServer().getPluginManager().callEvent((Event)event);
        }
        catch (Error | Exception ex) {
            CommandHelper.sendError(sender, "An error occurred while reloading!");
            ex.printStackTrace();
        }
        CommandHelper.sendSuccess(sender, "Mythic has finished reloading!");
        MythicLogger.log("Mythic has finished reloading!");
    }
}

