/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.items;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.utils.commands.Command;
import io.lumine.mythic.utils.config.properties.Property;
import io.lumine.mythic.utils.config.properties.types.BooleanProp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class GiveCommand
extends Command<MythicBukkit> {
    private static final BooleanProp GIVEITEMFEEDBACK = Property.Boolean(Scope.CONFIG, "Configuration.General.SendGiveItemFeedback", true);

    public GiveCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        boolean optSilent;
        boolean bl = optSilent = (Boolean)GIVEITEMFEEDBACK.get() == false;
        if (args != null && args.length > 2 && args[0].startsWith("-")) {
            if (args[0].startsWith("-s")) {
                optSilent = true;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length < 2) {
            if (!optSilent) {
                CommandHelper.sendError(sender, "Command Syntax: /mm item give <name> <item>");
            }
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        String item = args[1];
        int amount = 1;
        if (args.length > 2) {
            amount = Integer.valueOf(args[2]);
        }
        if (target == null) {
            if (!optSilent) {
                CommandHelper.sendError(sender, "That player is not online");
            }
            return true;
        }
        AbstractPlayer atarget = BukkitAdapter.adapt(target);
        DropMetadataImpl meta = new DropMetadataImpl(new GenericCaster(atarget), atarget);
        Optional<DropTable> maybeDrops = MythicBukkit.inst().getDropManager().getDropTable(item);
        if (maybeDrops.isPresent()) {
            DropTable dt = maybeDrops.get();
            if (dt.hasDrops()) {
                for (int i = 0; i < amount; ++i) {
                    LootBag loot = dt.generate(meta);
                    loot.give(atarget, optSilent);
                }
            }
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().isPresent()) {
                ((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().get().reparseWeapon(atarget);
            }
            BukkitAdapter.adapt(atarget).updateInventory();
            if (!optSilent) {
                CommandHelper.sendSuccess(sender, "DropTable &b" + item + " &awas put in your inventory!");
            }
            return true;
        }
        Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(item);
        if (maybeItem.isPresent()) {
            MythicItem mi = maybeItem.get();
            for (int i = 0; i < amount; ++i) {
                target.getInventory().addItem(new ItemStack[]{BukkitAdapter.adapt(mi.generateItemStack(meta, 1))});
            }
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().isPresent()) {
                ((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().get().reparseWeapon(BukkitAdapter.adapt(target));
            }
            target.updateInventory();
            if (!optSilent) {
                target.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Item " + ChatColor.AQUA + item + ChatColor.GREEN + " was put in your inventory!");
            }
        } else if (!optSilent) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "No Mythic Item loaded with the name " + item + ".");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                players.add(p.getName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], players, new ArrayList());
        }
        if (args.length == 2) {
            ArrayList<String> itemNames = new ArrayList<String>(((MythicBukkit)this.getPlugin()).getItemManager().getItemNames());
            for (DropTable s2 : ((MythicBukkit)this.getPlugin()).getDropManager().getDropTables()) {
                itemNames.add(s2.getInternalName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[1], itemNames, new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.give";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"g", "gi"};
    }
}

