/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.mobs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.utils.commands.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class KillTypeCommand
extends Command<MythicBukkit> {
    public KillTypeCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        int radius = 0;
        boolean exact = false;
        boolean literally = false;
        boolean vanilla = false;
        if (args != null && args.length > 1 && args[0].startsWith("-")) {
            if (args[0].contains("p")) {
                literally = true;
            }
            if (args[0].contains("e")) {
                exact = true;
            }
            if (args[0].contains("v")) {
                vanilla = true;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        String type = args[0];
        if (args.length > 1 && sender instanceof Player) {
            radius = Integer.parseInt(args[1]);
        }
        String s2 = ChatColor.GREEN + "Mobs Killed: ";
        for (LivingEntity l : ((MythicBukkit)this.getPlugin()).getMobManager().getAllMythicEntities()) {
            ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)l);
            if (am == null || !exact && !am.getType().getInternalName().contains(type) || exact && !am.getType().getInternalName().equalsIgnoreCase(type)) continue;
            am.setDespawned();
            ((MythicBukkit)this.getPlugin()).getMobManager().unregisterActiveMob(am);
            l.remove();
        }
        for (MythicMob mm4 : ((MythicBukkit)this.getPlugin()).getMobManager().getMobTypes()) {
            if (!exact && !mm4.getInternalName().contains(type) || exact && !mm4.getInternalName().equalsIgnoreCase(type)) continue;
            String[] parts = mm4.getInternalName().split(type);
            if (parts.length == 2) {
                s2 = s2 + ChatColor.RED + parts[0] + ChatColor.DARK_RED + type + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
            }
            if (parts.length == 1) {
                s2 = s2 + ChatColor.RED + parts[0] + ChatColor.DARK_RED + type + ChatColor.GRAY + ", ";
            }
            if (parts.length != 0) continue;
            s2 = s2 + ChatColor.DARK_RED + type + ChatColor.GRAY + ", ";
        }
        sender.sendMessage(s2);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args != null && args.length > 1 && args[0].startsWith("-")) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicBukkit)this.getPlugin()).getMobManager().getMobNames(), new ArrayList());
        }
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.kill";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "kill";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"k"};
    }
}

