/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class AddConditionCommand
extends Command<MythicBukkit> {
    public AddConditionCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(ChatColor.YELLOW + "Command: " + ChatColor.AQUA + "/mm spawners addcondition [condition]");
            sender.sendMessage(ChatColor.YELLOW + "View conditions on the Manual @ http://www.mythiccraft.io");
            return true;
        }
        String name = args[0];
        Object condition = "";
        for (int i = 1; i < args.length; ++i) {
            condition = ((String)condition).concat(args[i]) + " ";
        }
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicBukkit.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (MythicBukkit.inst().getSpawnerManager().addSpawnerCondition(ms, (String)condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Added spawner condition " + ChatColor.AQUA + (String)condition + ChatColor.GREEN + " on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
                if (MythicBukkit.inst().getSpawnerManager().addSpawnerCondition(ms, (String)condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + (String)condition + ChatColor.GREEN + " added to all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || MythicBukkit.inst().getSpawnerManager().addSpawnerCondition(ms, (String)condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner condition " + ChatColor.AQUA + (String)condition + ChatColor.GREEN + " added to spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicBukkit.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return true;
            }
            if (!MythicBukkit.inst().getSpawnerManager().addSpawnerCondition(ms, (String)condition)) {
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
            } else {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Added spawner condition " + ChatColor.AQUA + (String)condition);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.addcondition";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "addcondition";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"ac"};
    }
}

