/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.utils.commands.Command;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FindCommand
extends Command<MythicBukkit> {
    public FindCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        AbstractLocation pLoc = BukkitAdapter.adapt(p.getLocation());
        double radius = 32.0;
        if (args.length > 0 && (args[0].matches("(\\d+\\.\\d+)") || args[0].matches("(\\d+)"))) {
            radius = Double.parseDouble(args[0]);
        }
        CommandHelper.sendHeader(sender);
        sender.sendMessage("\u00a76Spawners within " + radius + " blocks of you:");
        for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
            try {
                double distance;
                if (ms.getLocation().getWorld() == null || !ms.getLocation().getWorld().getUniqueId().equals(pLoc.getWorld().getUniqueId()) || !((distance = ms.distanceTo(pLoc)) <= radius)) continue;
                TextComponent message = new TextComponent("\u00a76- \u00a7a" + ms.getInternalName() + " \u00a7b(" + distance + " blocks away");
                message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mythicmobs:mythicmobs spawners ui " + ms.getInternalName()));
                p.spigot().sendMessage((BaseComponent)message);
            }
            catch (Exception ex) {}
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.find";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "find";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"listnear", "ln"};
    }
}

