/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.utils.commands.Command;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;

public class RemoveCommand
extends Command<MythicBukkit> {
    public RemoveCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter the name of a mob spawner to remove!");
            return true;
        }
        String name = args[0];
        MythicSpawner ms = MythicBukkit.inst().getSpawnerManager().getSpawnerByName(name);
        if (ms == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "The spawner entered does not exist!");
            return true;
        }
        if (MythicBukkit.inst().getSpawnerManager().removeSpawner(ms)) {
            BukkitAdapter.adapt(ms.getLocation()).getWorld().playEffect(BukkitAdapter.adapt(ms.getLocation()), Effect.SMOKE, 0);
            BukkitAdapter.adapt(ms.getLocation()).getWorld().playEffect(BukkitAdapter.adapt(ms.getLocation()), Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner was removed successfully!");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.remove";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"re", "delete", "r"};
    }
}

