/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.events.MythicDropLoadEvent;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.utils.Events;
import io.lumine.mythic.utils.plugin.ReloadableModule;
import java.util.Optional;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.droptable.item.MMOItemDropItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.MushroomState;
import org.apache.commons.lang.Validate;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MMOItemsSupport
extends ReloadableModule<MythicBukkit> {
    public MMOItemsSupport(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(MythicDropLoadEvent.class).handler(event -> {
            if (event.getDropName().equalsIgnoreCase("mmoitems") || event.getDropName().equalsIgnoreCase("mmoitem")) {
                event.register(new MMOItemsDrop(event.getConfig()));
            }
        }).bindWith(this);
    }

    @Override
    public void unload() {
    }

    public boolean checkCustomBlock(Block block, int id) {
        Optional optional = MMOItems.plugin.getCustomBlocks().getFromBlock(block.getBlockData());
        if (optional.isPresent()) {
            CustomBlock custom = (CustomBlock)optional.get();
            return id == custom.getId();
        }
        return false;
    }

    public Material getCustomBlockMaterial(int id) {
        return MMOItems.plugin.getCustomBlocks().getBlock(id).getState().getType();
    }

    public MushroomState getCustomBlockState(int id) {
        return MMOItems.plugin.getCustomBlocks().getBlock(id).getState();
    }

    public AbstractBlock getMMOItemsBlock(int id) {
        return new MMOItemsBlock(id);
    }

    public ItemStack getCustomItem(String string) {
        try {
            String[] split = string.split("\\.");
            String typeFormat = split[0].toUpperCase().replace("-", "_");
            Type type = MMOItems.plugin.getTypes().get(typeFormat);
            String id = split[1];
            return MMOItems.plugin.getItems().getItem(type, id);
        }
        catch (IllegalArgumentException exception) {
            MythicLogger.error("Could not load drop item: " + exception.getMessage());
            return new ItemStack(Material.ZOMBIE_HORSE_SPAWN_EGG);
        }
    }

    public class MMOItemsBlock
    extends AbstractBlock {
        private final CustomBlock block;

        public MMOItemsBlock(int id) {
            this.block = MMOItems.plugin.getCustomBlocks().getBlock(id);
        }

        @Override
        public void set(AbstractLocation location) {
            if (this.block != null) {
                Location loc = BukkitAdapter.adapt(location);
                loc.getBlock().setBlockData(this.block.getState().getBlockData());
            }
        }

        @Override
        public void set(AbstractLocation location, int age, Bisected.Half bisectedHalf, BlockFace blockFace, Axis axis, Slab.Type slabType, boolean waterLogged, FaceAttachable.AttachedFace attachedFace, Stairs.Shape stairshape) {
        }
    }

    public class MMOItemsDrop
    implements IItemDrop {
        private Type type;
        private String id;
        private MMOItemDropItem dropItem;

        public MMOItemsDrop(MythicLineConfig config) {
            try {
                String typeFormat = config.getString("type").toUpperCase().replace("-", "_");
                Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(typeFormat), (String)("Could not find type with ID " + typeFormat));
                this.type = MMOItems.plugin.getTypes().get(typeFormat);
                this.id = config.getString("id");
                Validate.notNull((Object)this.id, (String)"MMOItems ID cannot be null");
                this.dropItem = new MMOItemDropItem(this.type, this.id, 1.0, config.getDouble("unidentified", 0.0), 1, 1);
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.WARNING, "Could not load drop item: " + exception.getMessage());
                return;
            }
        }

        @Override
        public AbstractItemStack getDrop(DropMetadata metadata, double amount) {
            if (this.dropItem != null) {
                PlayerData playerData = metadata.getTrigger() != null && metadata.getTrigger().isPlayer() ? PlayerData.get((OfflinePlayer)((Player)metadata.getTrigger().getBukkitEntity())) : null;
                ItemStack itemStack = this.dropItem.getItem(playerData, 1);
                if (itemStack == null) {
                    MythicLogger.errorCompatibility("MMOITEMS", "Item type " + this.type.getId() + "." + this.id + " not found");
                    return new BukkitItemStack(Material.STONE);
                }
                return new BukkitItemStack(this.dropItem.getItem(playerData, 1)).amount((int)amount);
            }
            return new BukkitItemStack(Material.STONE);
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public MMOItemDropItem getDropItem() {
            return this.dropItem;
        }
    }
}

