/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicReloadedEvent;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.cooldown.CooldownInfo;
import io.lumine.mythic.lib.player.cooldown.CooldownMap;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.utils.Events;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.plugin.ReloadableModule;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;

public class MythicLibSupport
extends ReloadableModule<MythicBukkit> {
    public MythicLibSupport(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(MythicMechanicLoadEvent.class).handler(event -> {
            if (event.getMechanicName().equalsIgnoreCase("mmodamage") || event.getMechanicName().equalsIgnoreCase("mmod")) {
                // empty if block
            }
        });
        Events.subscribe(MythicReloadedEvent.class).handler(event -> this.registerPlaceholders());
        Schedulers.sync().runLater(this::registerPlaceholders, 1L);
    }

    @Override
    public void unload() {
    }

    private void registerPlaceholders() {
        MythicBukkit.inst().getPlaceholderManager().register("modifier", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (!(metadata instanceof SkillMetadata)) {
                throw new RuntimeException("Cannot use this placeholder outside of skill");
            }
            Variable var = ((SkillMetadata)metadata).getVariables().get("MMOSkill");
            Validate.notNull((Object)var, (String)"Could not find MythicLib skill variable");
            return String.valueOf(((Skill)var.get()).getModifier(arg));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("mmodamage", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (!(metadata instanceof SkillMetadata)) {
                throw new RuntimeException("Cannot use this placeholder outside of skill");
            }
            SkillMetadata skillMeta = (SkillMetadata)metadata;
            Optional<AbstractEntity> damagedOpt = skillMeta.getEntityTargets().stream().findFirst();
            Validate.isTrue((boolean)damagedOpt.isPresent(), (String)"Could not find target entity");
            Entity damaged = damagedOpt.get().getBukkitEntity();
            AttackMetadata attackMeta = MythicLib.plugin.getDamage().findInfo(damaged);
            Validate.notNull((Object)attackMeta, (String)"Entity not being attacked");
            if (arg != null && !arg.isEmpty()) {
                DamageType type = DamageType.valueOf((String)UtilityMethods.enumName((String)arg));
                return String.valueOf(attackMeta.getDamage().getDamage(type));
            }
            return String.valueOf(attackMeta.getDamage().getDamage());
        }));
        MythicBukkit.inst().getPlaceholderManager().register("modifier.int", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (!(metadata instanceof SkillMetadata)) {
                throw new RuntimeException("Cannot use this placeholder outside of skill");
            }
            Variable var = ((SkillMetadata)metadata).getVariables().get("MMOSkill");
            Validate.notNull((Object)var, (String)"Could not find MythicLib skill variable");
            return String.valueOf((int)((Skill)var.get()).getModifier(arg));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("stat", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (metadata instanceof SkillMetadata && ((SkillMetadata)metadata).getVariables().has("MMOStatMap")) {
                PlayerMetadata statMap = (PlayerMetadata)((SkillMetadata)metadata).getVariables().get("MMOStatMap").get();
                return MythicLib.inst().getMMOConfig().decimals.format(statMap.getStat(arg.toUpperCase()));
            }
            SkillCaster caster = metadata.getCaster();
            if (!caster.getEntity().isPlayer()) {
                return "0";
            }
            MMOPlayerData playerData = MMOPlayerData.get((UUID)caster.getEntity().getUniqueId());
            return MythicLib.inst().getMMOConfig().decimals.format(playerData.getStatMap().getStat(arg.toUpperCase()));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("target.stat", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (!entity.isPlayer()) {
                return "0";
            }
            MMOPlayerData playerData = MMOPlayerData.get((UUID)entity.getUniqueId());
            return MythicLib.inst().getMMOConfig().decimals.format(playerData.getStatMap().getStat(arg.toUpperCase()));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("cooldown", (Placeholder)Placeholder.meta((metadata, arg) -> {
            CooldownMap cooldownMap = MMOPlayerData.get((UUID)metadata.getCaster().getEntity().getUniqueId()).getCooldownMap();
            CooldownInfo info = cooldownMap.getInfo(arg);
            return String.valueOf(info == null ? 0.0 : (double)info.getRemaining() / 1000.0);
        }));
    }
}

