/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;

public class BukkitExperienceOrb
extends BukkitEntityType {
    private static final int height = 1;
    private PlaceholderInt amount;

    @Override
    public void instantiate(MythicConfig mc) {
        String exp = mc.getString("Options.Experience", "1");
        try {
            this.amount = PlaceholderInt.of(exp);
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("Invalid experience amount specified");
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.EXPERIENCE_ORB, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        ExperienceOrb xp = (ExperienceOrb)entity;
        xp.setExperience(this.amount.get());
        return xp;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof ExperienceOrb;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

