/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.utils.items.ItemFactory;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;

public class BukkitItem
extends BukkitEntityType {
    private static final int height = 1;
    private String type = "STONE";
    private int amount = 1;
    private boolean canPickup = true;

    @Override
    public void instantiate(MythicConfig mc) {
        this.type = mc.getString("Options.Item", "STONE");
        this.amount = mc.getInteger("Options.Amount", 1);
        this.canPickup = mc.getBoolean("Options.CanPickup", true);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return location.getWorld().dropItem(location, ItemFactory.of(this.type).amount(this.amount).build());
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Item item = (Item)entity;
        item.setCanMobPickup(this.canPickup);
        item.setCanPlayerPickup(this.canPickup);
        return item;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Item;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

