/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PigZombie;

public class BukkitPigZombie
extends BukkitEntityType {
    private static final int height = 2;
    private boolean angry = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.angry = mc.getBoolean("Options.Angry", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        EntityType type = ServerVersion.isAfter(MinecraftVersions.v1_15) ? EntityType.valueOf((String)"ZOMBIFIED_PIGLIN") : EntityType.valueOf((String)"PIG_ZOMBIE");
        PigZombie e = (PigZombie)this.spawnEntity(location, type, reason, prespawnFunc);
        e.setBaby(false);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        PigZombie e = (PigZombie)entity;
        e.setAngry(this.angry);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitPigZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (e instanceof PigZombie) {
            return !((PigZombie)e).isBaby();
        }
        return false;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

