/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.entities.properties.EntityPropertySet;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.utils.serialize.InventorySerialization;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class MerchantProperty
implements EntityPropertySet {
    private final MythicConfig mc;
    private int level;
    private boolean hasTrades = true;
    private boolean hasDynamicTrades = false;
    private List<MerchantRecipe> trades;

    public MerchantProperty(MythicConfig mc) {
        this.mc = mc;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            this.level = mc.getInteger("Options.TradingLevel", 1);
            this.level = mc.getInteger("Options.Level", this.level);
        }
        this.hasTrades = mc.getBoolean("Options.HasTrades", true);
        if (mc.isSet("DynamicTrades")) {
            this.hasDynamicTrades = true;
        }
        if (mc.isSet("Trades")) {
            this.trades = new ArrayList<MerchantRecipe>();
            for (MythicConfig tradeConf : mc.getNestedConfigs("Trades").values()) {
                try {
                    int amount;
                    ItemStack result;
                    String strResult = tradeConf.getString("Result", "STONE");
                    String strItem1 = tradeConf.getString("Item1", "5 EMERALD");
                    String strItem2 = tradeConf.getString("Item2", null);
                    int maxUses = tradeConf.getInteger("MaxUses", 10000);
                    String[] spResult = strResult.split(" ");
                    ItemStack itemStack = result = spResult.length == 1 ? new BukkitItemStack(spResult[0]).build() : new BukkitItemStack(spResult[1]).build();
                    if (result.getType() != Material.PLAYER_HEAD) {
                        result = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(result));
                    }
                    if (spResult.length == 2) {
                        int amount2;
                        try {
                            amount2 = Integer.parseInt(spResult[0]);
                        }
                        catch (NumberFormatException exception) {
                            amount2 = 0;
                        }
                        result.setAmount(amount2);
                    }
                    MerchantRecipe recipe = new MerchantRecipe(result, maxUses);
                    if (strItem1 != null) {
                        String[] spItem1 = strItem1.split(" ");
                        ItemStack item1 = spItem1.length == 1 ? new BukkitItemStack(spItem1[0]).build() : new BukkitItemStack(spItem1[1]).build();
                        item1 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item1));
                        if (spItem1.length == 2) {
                            try {
                                amount = Integer.parseInt(spItem1[0]);
                            }
                            catch (NumberFormatException exception) {
                                amount = 0;
                            }
                            item1.setAmount(amount);
                        }
                        recipe.addIngredient(item1);
                    }
                    if (strItem2 != null) {
                        String[] spItem2 = strItem2.split(" ");
                        ItemStack item2 = spItem2.length == 1 ? new BukkitItemStack(spItem2[0]).build() : new BukkitItemStack(spItem2[1]).build();
                        item2 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item2));
                        if (spItem2.length == 2) {
                            try {
                                amount = Integer.parseInt(spItem2[0]);
                            }
                            catch (NumberFormatException exception) {
                                amount = 0;
                            }
                            item2.setAmount(amount);
                        }
                        recipe.addIngredient(item2);
                    }
                    this.trades.add(recipe);
                }
                catch (Exception ex) {
                    MythicLogger.errorGenericConfig("A villager trade with result " + tradeConf.getString("Result", "STONE") + " is configured incorrectly.");
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean hasTrades() {
        return this.trades != null && !this.trades.isEmpty() || this.hasDynamicTrades;
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if (!(entity instanceof Merchant)) {
            return entity;
        }
        Merchant merchant = (Merchant)entity;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Villager) {
            ((Villager)entity).setVillagerLevel(this.level);
        }
        if (this.hasTrades()) {
            ArrayList<MerchantRecipe> trades = Lists.newArrayList();
            if (this.trades != null) {
                trades.addAll(this.trades);
            }
            if (this.hasDynamicTrades) {
                for (MythicConfig tradeConf : this.mc.getNestedConfigs("DynamicTrades").values()) {
                    MerchantRecipe recipe = this.getDynamicRecipe(entity, tradeConf);
                    if (recipe == null) continue;
                    trades.add(recipe);
                }
            }
            merchant.setRecipes(trades);
        } else {
            merchant.setRecipes(Collections.emptyList());
        }
        return entity;
    }

    private MerchantRecipe getDynamicRecipe(Entity entity, MythicConfig tradeConf) {
        try {
            int amount;
            ItemStack result;
            String strResult = tradeConf.getString("Result", "STONE");
            String strItem1 = tradeConf.getString("Item1", "5 EMERALD");
            String strItem2 = tradeConf.getString("Item2", null);
            int maxUses = tradeConf.getInteger("MaxUses", 10000);
            String[] spResult = strResult.split(" ");
            ItemStack itemStack = result = spResult.length == 1 ? this.getItemFromTable(entity, spResult[0]) : this.getItemFromTable(entity, spResult[1]);
            if (result.getType() != Material.PLAYER_HEAD) {
                result = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(result));
            }
            if (spResult.length == 2) {
                int amount2;
                try {
                    amount2 = Integer.parseInt(spResult[0]);
                }
                catch (NumberFormatException exception) {
                    amount2 = 0;
                }
                result.setAmount(amount2);
            }
            MerchantRecipe recipe = new MerchantRecipe(result, maxUses);
            if (strItem1 != null) {
                String[] spItem1 = strItem1.split(" ");
                ItemStack item1 = spItem1.length == 1 ? this.getItemFromTable(entity, spItem1[0]) : this.getItemFromTable(entity, spItem1[1]);
                item1 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item1));
                if (spItem1.length == 2) {
                    try {
                        amount = Integer.parseInt(spItem1[0]);
                    }
                    catch (NumberFormatException exception) {
                        amount = 0;
                    }
                    item1.setAmount(amount);
                }
                recipe.addIngredient(item1);
            }
            if (strItem2 != null) {
                String[] spItem2 = strItem2.split(" ");
                ItemStack item2 = spItem2.length == 1 ? this.getItemFromTable(entity, spItem2[0]) : this.getItemFromTable(entity, spItem2[1]);
                item2 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item2));
                if (spItem2.length == 2) {
                    try {
                        amount = Integer.parseInt(spItem2[0]);
                    }
                    catch (NumberFormatException exception) {
                        amount = 0;
                    }
                    item2.setAmount(amount);
                }
                recipe.addIngredient(item2);
            }
            return recipe;
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("A villager trade with result " + tradeConf.getString("Result", "STONE") + " is configured incorrectly.");
            ex.printStackTrace();
            return null;
        }
    }

    private ItemStack getItemFromTable(Entity entity, String itemString) {
        DropTable table;
        Optional<DropTable> maybeTable = MythicBukkit.inst().getDropManager().getDropTable(itemString);
        if (maybeTable.isPresent()) {
            table = maybeTable.get();
        } else {
            if (itemString.startsWith("\"")) {
                try {
                    itemString = itemString.substring(1, itemString.length() - 1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                itemString = SkillString.parseMessageSpecialChars(itemString);
            }
            ArrayList<String> items = Lists.newArrayList();
            for (String s2 : itemString.split(",")) {
                items.add(s2);
            }
            table = new DropTable("DropItemMechanic", "DropItemMechanic", items);
        }
        AbstractEntity aEntity = BukkitAdapter.adapt(entity);
        DropMetadataImpl meta = new DropMetadataImpl(new GenericCaster(aEntity), aEntity);
        ItemStack ret = new ItemStack(Material.AIR);
        for (Drop type : table.generate(meta).getDrops()) {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) continue;
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (!(drop instanceof IItemDrop)) continue;
            ret = ((BukkitItemStack)((IItemDrop)drop).getDrop(meta, amount)).build();
            break;
        }
        return ret;
    }
}

