/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.listeners;

import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.utils.Events;
import io.lumine.mythic.utils.plugin.ReloadableModule;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class ChunkListeners
extends ReloadableModule<MythicBukkit>
implements Listener {
    public ChunkListeners(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        if (ServerVersion.isAfter(MinecraftVersions.v1_17)) {
            try {
                Events.subscribe(EntitiesLoadEvent.class).handler(this::scanChunk).bindWith(this);
            }
            catch (Error | Exception throwable) {}
        } else {
            Events.subscribe(ChunkLoadEvent.class).handler(this::scanChunk).bindWith(this);
        }
        if (ServerVersion.isAfter(MinecraftVersions.v1_17)) {
            try {
                Events.subscribe(EntitiesUnloadEvent.class).handler(this::unloadChunkEntities).bindWith(this);
            }
            catch (Error | Exception throwable) {}
        } else {
            Events.subscribe(ChunkUnloadEvent.class).handler(this::unloadChunkEntitiesOld).bindWith(this);
        }
        Events.subscribe(ChunkUnloadEvent.class).handler(this::unloadChunk).bindWith(this);
        Events.subscribe(WorldUnloadEvent.class).handler(this::unloadWorld).bindWith(this);
    }

    @Override
    public void unload() {
    }

    private void scanChunk(ChunkEvent event) {
        Chunk chunk = event.getChunk();
        if (!chunk.isLoaded()) {
            return;
        }
        Entity[] el = chunk.getEntities();
        if (el.length == 0) {
            return;
        }
        for (Entity ee : el) {
            ActiveMob am;
            if (!(ee instanceof LivingEntity) || ee instanceof Player) continue;
            LivingEntity l = (LivingEntity)ee;
            if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(ee.getUniqueId())) {
                if (l.getRemoveWhenFarAway()) {
                    ee.remove();
                    continue;
                }
                am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee));
                if (am == null || am.getType() == null) {
                    ee.remove();
                    continue;
                }
                if (am.getType().getDespawnMode().getDespawnsOnUnload().booleanValue()) {
                    am.despawn();
                    continue;
                }
                am.loadSaved();
                continue;
            }
            am = ((MythicBukkit)this.getPlugin()).getMobManager().registerActiveMob(BukkitAdapter.adapt((Entity)l));
            if (am == null) continue;
        }
    }

    private void unloadChunkEntities(EntitiesUnloadEvent e) {
        for (Entity ee : e.getEntities()) {
            ActiveMob am;
            if (!(ee instanceof LivingEntity) || ee == null || !((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(ee.getUniqueId()) || (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee))) == null) continue;
            if (am.getType() != null && am.getType().getDespawnMode().getDespawnsOnUnload().booleanValue()) {
                am.despawn();
                continue;
            }
            am.setUnloaded();
        }
    }

    private void unloadChunk(ChunkUnloadEvent e) {
        String cS = e.getChunk().getWorld().getName() + "-" + e.getChunk().getX() + "-" + e.getChunk().getZ();
        Optional<Collection<MythicSpawner>> maybeSpawners = ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawnersByChunk(cS);
        if (maybeSpawners.isPresent()) {
            for (MythicSpawner ms : maybeSpawners.get()) {
                ms.unloadSpawner();
            }
        }
    }

    private void unloadChunkEntitiesOld(ChunkUnloadEvent e) {
        for (Entity ee : e.getChunk().getEntities()) {
            ActiveMob am;
            if (!(ee instanceof LivingEntity) || !((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(ee.getUniqueId()) || (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee))) == null || am.getType() == null || !am.getType().getDespawnMode().getDespawnsOnUnload().booleanValue()) continue;
            am.despawn();
        }
    }

    public void unloadWorld(WorldUnloadEvent e) {
        for (Entity ee : e.getWorld().getEntities()) {
            ActiveMob am;
            if (!(ee instanceof LivingEntity) || !((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(ee.getUniqueId()) || (am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee))) == null) continue;
            if (am.getType().getDespawnMode().getDespawnsOnUnload().booleanValue()) {
                am.despawn();
                continue;
            }
            am.setUnloaded();
        }
    }
}

