/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticDouble;
import io.lumine.mythic.core.utils.MathParser;
import io.lumine.mythic.utils.collections.AWeightedItem;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.numbers.RandomDouble;

public abstract class Drop
extends AWeightedItem
implements Cloneable,
IDrop {
    private final String line;
    private final MythicLineConfig config;
    protected String dropVar;
    private PlaceholderDouble dropAmount;
    private double amount;

    public Drop(String line, MythicLineConfig config) {
        block13: {
            this.dropVar = null;
            this.dropAmount = new StaticDouble("1");
            this.amount = 1.0;
            this.line = line;
            this.config = config;
            try {
                String[] split = line.split(" ");
                if (split[0].contains(":")) {
                    String[] split2 = split[0].split(":");
                    this.dropVar = split2[1];
                }
                if (split.length == 2) {
                    if (RandomDouble.matches(split[1]) || split[1].startsWith("'")) {
                        this.dropAmount = PlaceholderDouble.of(split[1]);
                        if (this.dropAmount.isStatic() && this.dropAmount.get() < 1.0) {
                            this.weight = this.dropAmount.get();
                            this.dropAmount = new StaticDouble("1");
                        }
                    } else {
                        this.dropVar = split[1];
                    }
                } else if (split.length == 3) {
                    if (RandomDouble.matches(split[1]) || split[1].startsWith("'")) {
                        this.dropAmount = PlaceholderDouble.of(split[1]);
                        this.weight = MathParser.evalChance(split[2]);
                    } else {
                        this.dropVar = split[1];
                        this.dropAmount = PlaceholderDouble.of(split[2]);
                    }
                } else if (split.length >= 4) {
                    this.dropVar = split[1];
                    this.dropAmount = PlaceholderDouble.of(split[2]);
                    this.weight = MathParser.evalChance(split[3]);
                }
            }
            catch (Exception ex) {
                MythicLogger.errorDropConfig(this, config, "Invalid Syntax");
                if (ConfigManager.debugLevel <= 0) break block13;
                ex.printStackTrace();
            }
        }
    }

    public Drop(String line, MythicLineConfig config, double amount) {
        this(line, config);
        this.dropAmount = new StaticDouble(amount);
    }

    public Drop(String line, MythicLineConfig config, RandomDouble amount) {
        this(line, config);
        this.dropAmount = new io.lumine.mythic.core.skills.placeholders.parsers.RandomDouble(amount);
    }

    public boolean rollChance() {
        return this.weight == 1.0 || !(Numbers.randomDouble() > this.weight);
    }

    public void rollAmount(DropMetadata data) {
        this.amount = this.dropAmount.get(data);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().equals(this.getClass());
    }

    public Drop addAmount(Drop other) {
        this.amount += other.getAmount();
        return this.clone();
    }

    public Drop clone() {
        try {
            return (Drop)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLine() {
        return this.line;
    }

    public MythicLineConfig getConfig() {
        return this.config;
    }

    public String getDropVar() {
        return this.dropVar;
    }

    public PlaceholderDouble getDropAmount() {
        return this.dropAmount;
    }

    public void setDropAmount(PlaceholderDouble dropAmount) {
        this.dropAmount = dropAmount;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }
}

