/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops.droppables;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IMultiDrop;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.ExperienceDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.drops.droppables.VaultDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.ArrayList;
import org.bukkit.inventory.ItemStack;

public class PhatLootsDrop
extends Drop
implements IMultiDrop {
    private String lootString;

    public PhatLootsDrop(String line, MythicLineConfig config) {
        super(line, config);
        this.lootString = config.getString(new String[]{"type", "t"}, this.dropVar, new String[0]);
    }

    @Override
    public LootBag get(DropMetadata meta) {
        LootBag loot = new LootBag(meta);
        if (CompatibilityManager.PhatLoots == null) {
            MythicLogger.error("Phatloots isn't loaded!");
            return loot;
        }
        if (this.lootString != null && CompatibilityManager.PhatLoots != null) {
            ArrayList<ItemStack> dropsList = new ArrayList<ItemStack>();
            int exp = 0;
            int money = 0;
            int i = 0;
            while ((double)i < this.getAmount()) {
                if (CompatibilityManager.PhatLoots.generateBundle(this.lootString)) {
                    dropsList.addAll(CompatibilityManager.PhatLoots.getLootBundleItems());
                    exp += CompatibilityManager.PhatLoots.getLootBundleXP();
                    money = (int)((double)money + CompatibilityManager.PhatLoots.getLootBundleMoney());
                }
                ++i;
            }
            for (ItemStack item : dropsList) {
                loot.add(meta, new ItemDrop(this.getLine(), this.getConfig(), new BukkitItemStack(item)));
            }
            if (exp > 0) {
                loot.add(meta, new ExperienceDrop(this.getLine(), this.getConfig(), exp));
            }
            if (money > 0) {
                loot.add(meta, new VaultDrop(this.getLine(), this.getConfig(), money));
            }
        }
        return loot;
    }
}

