/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.holograms;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.holograms.HologramProvider;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.core.holograms.types.CastBar;
import io.lumine.mythic.core.holograms.types.HealthBar;
import io.lumine.mythic.core.holograms.types.Nameplate;
import io.lumine.mythic.core.holograms.types.SpeechBubble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.mechanics.CastMechanic;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.logging.ConsoleColor;
import io.lumine.mythic.utils.plugin.ReloadableModule;

public class HologramManager
extends ReloadableModule<MythicBukkit> {
    private final CompatibilityManager compat;
    private HologramProvider provider;

    public HologramManager(MythicBukkit core, CompatibilityManager compat) {
        super(core);
        this.compat = compat;
    }

    @Override
    public void load(MythicBukkit plugin) {
        Schedulers.sync().runLater(() -> this.initialize(), 1L);
    }

    @Override
    public void unload() {
    }

    private void initialize() {
        if (this.compat.getHolograms().isPresent()) {
            MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + "Using Holograms plugin for holograms");
            this.provider = this.compat.getHolograms().get();
        } else if (this.compat.getHolographicDisplays().isPresent()) {
            MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + "Using HolographicDisplays plugin for holograms");
            this.provider = this.compat.getHolographicDisplays().get();
        } else {
            this.provider = null;
            return;
        }
    }

    public boolean isActive() {
        return this.provider != null;
    }

    public IHologram createHologram(String name, AbstractLocation location) {
        return this.provider == null ? null : this.provider.createHologram(name, location, " ");
    }

    public IHologram createHologram(String name, AbstractLocation location, String text) {
        return this.provider == null ? null : this.provider.createHologram(name, location, text);
    }

    public Nameplate createNameplate(ActiveMob activeMob) {
        return this.provider == null ? null : new Nameplate(this, activeMob);
    }

    public HealthBar createHealthBar(ActiveMob activeMob) {
        return this.provider == null ? null : new HealthBar(this, activeMob);
    }

    public SpeechBubble createSpeechBubble(SkillCaster skillCaster) {
        return this.provider == null ? null : new SpeechBubble(this, skillCaster);
    }

    public CastBar createCastBar(CastMechanic.CastTracker castTracker, String castingText) {
        return this.provider == null ? null : new CastBar(this, castTracker, castingText);
    }
}

