/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.items;

import io.lumine.mythic.api.items.ItemManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemExecutor
implements ItemManager {
    private final MythicBukkit core;
    private List<File> itemFiles;
    private IOLoader<MythicBukkit> defaultItems;
    private List<IOLoader<MythicBukkit>> itemLoaders;
    private ConcurrentHashMap<String, MythicItem> items = new ConcurrentHashMap();

    public ItemExecutor(MythicBukkit core) {
        this.core = core;
    }

    public void loadItems() {
        this.defaultItems = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleItems.yml", "Items");
        this.itemFiles = IOHandler.getAllFiles(this.defaultItems.getFile().getParent());
        File packsFolder = new File(this.core.getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "Items")).exists() || !confFolder.isDirectory()) continue;
                this.itemFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        this.itemLoaders = IOHandler.getSaveLoad(this.core, this.itemFiles, "Items");
        this.items.clear();
        for (IOLoader iOLoader : this.itemLoaders) {
            for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfigImpl mc = new MythicConfigImpl(name, iOLoader.getFile(), iOLoader.getCustomConfig());
                MythicItem mi = new MythicItem(iOLoader.getFile().getName(), name, mc);
                this.registerItem(name, mi);
            }
        }
    }

    @Override
    public Collection<MythicItem> getItems() {
        return this.items.values();
    }

    @Override
    public Collection<String> getItemNames() {
        return this.items.keySet();
    }

    @Override
    public Optional<MythicItem> getItem(String name) {
        return Optional.ofNullable(this.items.getOrDefault(name, null));
    }

    public ItemStack getItemStack(String name) {
        Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(name);
        if (maybeItem.isPresent()) {
            return BukkitAdapter.adapt(maybeItem.get().generateItemStack(1));
        }
        try {
            return new ItemStack(Material.valueOf((String)name.toUpperCase()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean registerItem(String internalName, MythicItem item) {
        if (this.items.containsKey(internalName)) {
            return false;
        }
        this.items.put(internalName, item);
        return true;
    }

    public String getItemAttribute(String input) {
        String attribute;
        if (ServerVersion.isBeforeOrEq(MinecraftVersions.v1_15)) {
            switch (input.toUpperCase()) {
                case "DAMAGE": 
                case "ATTACK_DAMAGE": 
                case "ATTACKDAMAGE": {
                    attribute = "generic.attackDamage";
                    break;
                }
                case "HEALTH": 
                case "MAX_HEALTH": 
                case "MAXHEALTH": 
                case "HP": {
                    attribute = "generic.maxHealth";
                    break;
                }
                case "MOVEMENT_SPEED": 
                case "MOVEMENTSPEED": 
                case "MOVESPEED": 
                case "RUNSPEED": 
                case "RUN_SPEED": {
                    attribute = "generic.movementSpeed";
                    break;
                }
                case "ATTACK_SPEED": 
                case "ATTACKSPEED": 
                case "WEAPON_SPEED": 
                case "WEAPONSPEED": {
                    attribute = "generic.attackSpeed";
                    break;
                }
                case "KNOCKBACK": 
                case "ATTACKKNOCKBACK": 
                case "ATTACK_KNOCKBACK": {
                    attribute = "generic.attackKnockback";
                    break;
                }
                case "KNOCKBACK_RESISTANCE": 
                case "KNOCKBACKRESISTANCE": 
                case "KNOCKBACKRESIST": {
                    attribute = "generic.knockbackResistance";
                    break;
                }
                case "ARMOR": {
                    attribute = "generic.armor";
                    break;
                }
                case "ARMOR_TOUGHNESS": 
                case "TOUGHNESS": 
                case "ARMORTOUGHNESS": {
                    attribute = "generic.armorToughness";
                    break;
                }
                case "LUCK": {
                    attribute = "generic.luck";
                    break;
                }
                default: {
                    attribute = input;
                    break;
                }
            }
        } else {
            switch (input.toUpperCase()) {
                case "DAMAGE": 
                case "ATTACK_DAMAGE": 
                case "ATTACKDAMAGE": {
                    attribute = "generic.attack_damage";
                    break;
                }
                case "HEALTH": 
                case "MAX_HEALTH": 
                case "MAXHEALTH": 
                case "HP": {
                    attribute = "generic.max_health";
                    break;
                }
                case "MOVEMENT_SPEED": 
                case "MOVEMENTSPEED": 
                case "MOVESPEED": 
                case "RUNSPEED": 
                case "RUN_SPEED": {
                    attribute = "generic.movement_speed";
                    break;
                }
                case "ATTACK_SPEED": 
                case "ATTACKSPEED": 
                case "WEAPON_SPEED": 
                case "WEAPONSPEED": {
                    attribute = "generic.attack_speed";
                    break;
                }
                case "KNOCKBACK": 
                case "ATTACKKNOCKBACK": 
                case "ATTACK_KNOCKBACK": {
                    attribute = "generic.attack_knockback";
                    break;
                }
                case "KNOCKBACK_RESISTANCE": 
                case "KNOCKBACKRESISTANCE": 
                case "KNOCKBACKRESIST": {
                    attribute = "generic.knockback_resistance";
                    break;
                }
                case "ARMOR": {
                    attribute = "generic.armor";
                    break;
                }
                case "ARMOR_TOUGHNESS": 
                case "TOUGHNESS": 
                case "ARMORTOUGHNESS": {
                    attribute = "generic.armor_toughness";
                    break;
                }
                case "LUCK": {
                    attribute = "generic.luck";
                    break;
                }
                default: {
                    attribute = input;
                }
            }
        }
        return attribute;
    }
}

