/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class EntityManager
implements Listener {
    private Set<AbstractPlayer> cachedAllPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    private ConcurrentHashMap<AbstractWorld, List<AbstractEntity>> cachedLivingEntities;
    private ConcurrentHashMap<AbstractWorld, List<AbstractPlayer>> cachedPlayers;
    private Set<Player> onlinePlayers = Collections.newSetFromMap(new ConcurrentHashMap());

    public EntityManager() {
        this.cachedPlayers = new ConcurrentHashMap();
        this.cachedLivingEntities = new ConcurrentHashMap();
        this.refreshCaches();
    }

    public synchronized void refreshCaches() {
        this.cachedAllPlayers.clear();
        this.cachedPlayers.clear();
        this.cachedLivingEntities.clear();
        for (AbstractWorld world : MythicBukkit.inst().getBootstrap().getWorlds()) {
            this.cachedAllPlayers.addAll(world.getPlayers());
            this.cachedPlayers.put(world, world.getPlayers());
            this.cachedLivingEntities.put(world, world.getLivingEntities());
        }
    }

    public synchronized List<AbstractEntity> getLivingEntities(AbstractWorld world) {
        return this.cachedLivingEntities.get(world);
    }

    public synchronized Collection<AbstractPlayer> getPlayers() {
        return this.cachedAllPlayers;
    }

    public synchronized List<AbstractPlayer> getPlayers(AbstractWorld world) {
        return this.cachedPlayers.get(world);
    }

    public synchronized void registerMob(AbstractWorld world, AbstractEntity entity) {
        this.cachedLivingEntities.get(world).add(entity);
    }

    public Set<AbstractPlayer> getPlayersInRangeSq(AbstractLocation location, int rangeSq) {
        HashSet<AbstractPlayer> inRange = new HashSet<AbstractPlayer>();
        try {
            if (!this.cachedPlayers.containsKey(location.getWorld())) {
                return Collections.emptySet();
            }
            this.cachedPlayers.get(location.getWorld()).stream().forEach(player -> {
                if (player.getWorld().equals(location.getWorld()) && player.getLocation().distanceSquared(location) <= (double)rangeSq) {
                    inRange.add((AbstractPlayer)player);
                }
            });
            return inRange;
        }
        catch (Exception ex) {
            return Collections.emptySet();
        }
    }

    public Set<Player> getOnlinePlayers() {
        return this.onlinePlayers;
    }
}

