/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.mobs.MobManager;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.SerializingComponent;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.CasterRegistry;
import io.lumine.mythic.core.mobs.MobRegistry;
import io.lumine.mythic.core.mobs.MobStack;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.logging.ConsoleColor;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.serialization.WrappedJsonFile;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class MobExecutor
extends SerializingComponent
implements MobManager,
CasterRegistry {
    private static final String FOLDER_MOBS = "Mobs";
    private Map<String, MythicMob> mmList = Maps.newConcurrentMap();
    private Map<String, MythicMob> mmDisplayLookup = Maps.newConcurrentMap();
    private List<MobStack> listMobStacks = Lists.newArrayList();
    private Map<MythicEntityType, MythicMob> mmDefaultList = Maps.newConcurrentMap();
    private WrappedJsonFile<MobRegistry> mobRegistry;
    private transient Map<UUID, ActiveMob> activeMobsInCombat = Maps.newConcurrentMap();
    private transient Cache<UUID, Boolean> mmVoidList = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<UUID, Boolean>(){

        @Override
        public Boolean load(UUID uuid) {
            return true;
        }
    });
    public static boolean spawnflag = false;
    public static boolean mountflag = false;

    public MobExecutor(MythicBukkit core) {
        super(core);
    }

    @Override
    public void load(MythicBukkit plugin) {
        MythicLogger.log("Loading Mob Registry...");
        try {
            this.mobRegistry = this.loadFile(this.getModuleFile("active-mobs.json"), MobRegistry.class);
            Schedulers.sync().runLater(() -> {
                if (this.mobRegistry.get() == null) {
                    this.regenerateMobRegistry();
                }
                this.mobRegistry.get().loadSaved();
            }, 1L);
        }
        catch (Exception ex) {
            this.regenerateMobRegistry();
        }
    }

    @Override
    public void unload() {
        this.mobRegistry.get().terminate();
        this.mobRegistry.save();
    }

    public void regenerateMobRegistry() {
        try {
            MythicLogger.error(ConsoleColor.RED + "----------------------------------------");
            MythicLogger.error(ConsoleColor.YELLOW + "Failed to load active-mobs.json: file may have been corrupted during a server crash or improper shutdown.");
            MythicLogger.error(ConsoleColor.YELLOW + "This file has been regenerated and a backup has been saved of the old one.");
            MythicLogger.error(ConsoleColor.RED + "----------------------------------------");
            File file = this.getModuleFile("active-mobs.json");
            if (file.exists()) {
                int i = 1;
                File copyFile = this.getModuleFile("active-mobs.corrupt" + i + ".json");
                while (copyFile.exists()) {
                    copyFile = this.getModuleFile("active-mobs.corrupt" + ++i + ".json");
                }
                file.renameTo(copyFile);
            }
            this.mobRegistry = new WrappedJsonFile<MobRegistry>(this, this.getModuleFile("active-mobs.json"), (MobRegistry)MobRegistry.class.newInstance());
        }
        catch (Error | Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void loadMobs() {
        MobType mm4;
        MythicConfigImpl mc;
        IOLoader<MythicBukkit> defaultMobs = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "VanillaMobs.yml", FOLDER_MOBS);
        defaultMobs = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleMobs.yml", FOLDER_MOBS);
        List<File> mobFiles = IOHandler.getAllFiles(defaultMobs.getFile().getParent());
        File packsFolder = new File(((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                Object confFolder;
                if (!packFolder.isDirectory() || !((File)(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + FOLDER_MOBS))).exists() || !((File)confFolder).isDirectory()) continue;
                mobFiles.addAll(IOHandler.getAllFiles(((File)confFolder).getAbsolutePath()));
            }
        }
        List<IOLoader<MythicBukkit>> mobLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), mobFiles, FOLDER_MOBS);
        this.mmList.clear();
        this.mmDefaultList.clear();
        this.mmDisplayLookup.clear();
        ArrayList<Object[]> mobsUsingTemplates = new ArrayList<Object[]>();
        for (IOLoader<MythicBukkit> sl : mobLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                try {
                    mc = new MythicConfigImpl(name, sl.getFile(), sl.getCustomConfig());
                    String file = sl.getFile().getPath();
                    if (BukkitEntityType.getMythicEntity(name) != null) {
                        MythicEntityType met = MythicEntityType.get(name);
                        mm4 = new MobType(this, file, name, mc);
                        this.mmDefaultList.put(met, mm4);
                        this.mmList.put(met.toString(), mm4);
                        continue;
                    }
                    if (sl.getCustomConfig().getString(name + ".MobStack") != null) {
                        String stack = sl.getCustomConfig().getString(name + ".MobStack");
                        this.listMobStacks.add(new MobStack(name, stack, file));
                        continue;
                    }
                    String display = sl.getCustomConfig().getString(name + ".Display");
                    display = sl.getCustomConfig().getString(name + ".DisplayName", display);
                    if (sl.getCustomConfig().getString(name + ".Template") != null) {
                        mobsUsingTemplates.add(new Object[]{file, name, mc, display});
                        continue;
                    }
                    mm4 = new MobType(this, file, name, mc);
                    this.mmList.put(name, mm4);
                    if (display == null) continue;
                    this.mmDisplayLookup.put(display, mm4);
                }
                catch (Exception ex) {
                    MythicLogger.error("Error loading mob '" + name + "'. Enable debugging for a stack trace.");
                    if (ConfigManager.debugLevel <= 0) continue;
                    ex.printStackTrace();
                }
            }
        }
        for (Object[] mobData : mobsUsingTemplates) {
            String name;
            String file = (String)mobData[0];
            name = (String)mobData[1];
            mc = (MythicConfigImpl)mobData[2];
            String display = (String)mobData[3];
            String templateID = mc.getString("Template");
            if (this.mmList.containsKey(templateID)) {
                MythicConfigImpl configToInherit = (MythicConfigImpl)this.mmList.get(templateID).getConfig();
                mc.merge(configToInherit, mc.getStringList("Exclude"));
            }
            mm4 = new MobType(this, file, name, mc);
            this.mmList.put(name, mm4);
            if (display == null) continue;
            this.mmDisplayLookup.put(display, mm4);
        }
    }

    @Override
    public Collection<MythicMob> getMobTypes() {
        return this.mmList.values();
    }

    @Override
    public Collection<String> getMobNames() {
        return this.mmList.keySet();
    }

    @Override
    public Collection<MythicMob> getVanillaTypes() {
        return this.mmDefaultList.values();
    }

    @Override
    public Optional<MythicMob> getVanillaType(MythicEntityType type) {
        return Optional.ofNullable(this.mmDefaultList.getOrDefault((Object)type, null));
    }

    @Override
    public Collection<MobStack> getMobStacks() {
        return this.listMobStacks;
    }

    @Override
    public Optional<SkillCaster> getSkillCaster(UUID uuid) {
        return Optional.ofNullable(this.mobRegistry.get().get(uuid));
    }

    @Override
    public Collection<ActiveMob> getActiveMobs() {
        return this.mobRegistry.get().values();
    }

    @Override
    public Collection<ActiveMob> getActiveMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean isLoadedMob(AbstractEntity entity) {
        return this.isLoadedMob(entity.getUniqueId());
    }

    public boolean isLoadedMob(UUID uuid) {
        return this.mobRegistry.get().isLoadedMob(uuid);
    }

    public boolean isActiveMob(AbstractEntity entity) {
        return this.isActiveMob(entity.getUniqueId());
    }

    public boolean isActiveMob(UUID uuid) {
        return this.mobRegistry.get().isActiveMob(uuid);
    }

    public Optional<ActiveMob> getActiveMob(UUID uuid) {
        return this.mobRegistry.get().getActiveMob(uuid);
    }

    public Set<UUID> getVoidList() {
        return this.mmVoidList.asMap().keySet();
    }

    public void setIgnoreEntity(UUID uuid) {
        this.mmVoidList.put(uuid, true);
    }

    public boolean isIgnoredEntity(UUID uuid) {
        return this.mmVoidList.asMap().keySet().contains(uuid);
    }

    public int removeAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.get().values()) {
            if (am.getType() != null && !am.getType().getDespawnMode().getObeysKillCommand().booleanValue()) continue;
            am.setDespawned();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int removeAllAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.get().values()) {
            am.setDespawned();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int despawnAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.get().values()) {
            if (!am.getType().getDespawnMode().getObeysKillCommand().booleanValue()) continue;
            am.setDespawnedSync();
            MythicBukkit.inst().getMobManager().unregisterActiveMob(am);
            if (am.getEntity() != null) {
                am.getEntity().remove();
            }
            ++amount;
        }
        return amount;
    }

    public void setEntityDespawned(UUID uniqueId) {
        this.mobRegistry.get().getActiveMob(uniqueId).ifPresent(mob -> mob.setDespawned());
    }

    public void ScanWorld() {
        Schedulers.async().run(() -> {
            for (AbstractWorld w : ((MythicBukkit)this.getPlugin()).getBootstrap().getWorlds()) {
                for (AbstractEntity e : ((MythicBukkit)this.getPlugin()).getEntityManager().getLivingEntities(w)) {
                    if (!this.isActiveMob(e)) {
                        Schedulers.sync().run(() -> this.registerActiveMob(e));
                        continue;
                    }
                    this.verifyMythicMobInstance(e);
                }
            }
            for (ActiveMob am : this.getActiveMobs()) {
                if (!am.isDead()) continue;
                am.setDespawned();
            }
        });
    }

    public ActiveMob registerActiveMob(ActiveMob am) {
        this.mobRegistry.get().put(am.getUniqueId(), am);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l, MythicMob mm4, int level) {
        if (this.isActiveMob(l)) {
            return this.getMythicMobInstance(l);
        }
        ActiveMob am = new ActiveMob(l, mm4, level);
        this.mobRegistry.get().put(l.getUniqueId(), am);
        mm4.applyMobVolatileOptions(am);
        new TriggeredSkill(SkillTriggers.SPAWN, am, null);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l) {
        String mobType;
        if (this.mmVoidList.asMap().containsKey(l.getUniqueId())) {
            return null;
        }
        if (this.isActiveMob(l)) {
            ActiveMob am = this.getMythicMobInstance(l);
            am.loadSaved();
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading Mob {0} from Registry", l.getUniqueId());
            return am;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && (mobType = (String)l.getDataContainer().getOrDefault(MobKeys.TYPE, PersistentDataType.STRING, null)) != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading Mob {0} from PersistentData", l.getUniqueId());
            ActiveMob am = new ActiveMob(l);
            this.mobRegistry.get().put(l.getUniqueId(), am);
            if (am.loadSaved()) {
                return am;
            }
            this.mobRegistry.get().removeMob(l.getUniqueId());
            return null;
        }
        this.mmVoidList.put(l.getUniqueId(), true);
        return null;
    }

    public void unregisterActiveMob(UUID u) {
        this.mobRegistry.get().removeMob(u);
        this.activeMobsInCombat.remove(u);
    }

    public void unregisterActiveMob(ActiveMob am) {
        if (am.getType().getModel() != null) {
            am.getType().getModel().remove(am.getEntity());
        }
        this.unregisterActiveMob(am.getUniqueId());
    }

    public ActiveMob getMythicMobInstance(Entity target) {
        return this.getMythicMobInstance(BukkitAdapter.adapt(target));
    }

    public ActiveMob getMythicMobInstance(AbstractEntity target) {
        ActiveMob am;
        if (this.mobRegistry.get() == null) {
            this.regenerateMobRegistry();
        }
        if ((am = this.mobRegistry.get().get(target.getUniqueId())) != null) {
            this.resetActiveMobEntity(am, target);
            return am;
        }
        return this.registerActiveMob(target);
    }

    public void verifyMythicMobInstance(AbstractEntity e) {
        ActiveMob am = this.mobRegistry.get().get(e.getUniqueId());
        if (am != null) {
            this.resetActiveMobEntity(am, e);
        }
    }

    private void resetActiveMobEntity(ActiveMob am, AbstractEntity e) {
        if ((am.getEntity() == null || !am.getEntity().isValid()) && e != null && e.isValid()) {
            am.setEntity(e);
        }
    }

    public ActiveMob spawnMob(String type, Location loc) {
        return this.spawnMob(type, BukkitAdapter.adapt(loc), SpawnReason.OTHER, 1.0);
    }

    public ActiveMob spawnMob(String type, Location loc, double level) {
        return this.spawnMob(type, BukkitAdapter.adapt(loc), SpawnReason.OTHER, level);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc) {
        return this.spawnMob(type, loc, SpawnReason.OTHER, 1.0);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, double level) {
        return this.spawnMob(type, loc, SpawnReason.OTHER, level);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, SpawnReason reason, double level) {
        MythicMob mm4 = this.getMythicMob(type).orElseGet(() -> null);
        if (mm4 != null) {
            return mm4.spawn(loc, level, reason);
        }
        MobStack ms = MythicBukkit.inst().getMobManager().getMythicMobStack(type);
        if (ms != null) {
            return ms.spawn(loc, level, reason);
        }
        return null;
    }

    public void SetupMythicMobCompat(LivingEntity l, MythicMob mm4) {
        if (spawnflag) {
            return;
        }
        if (mm4.getMythicEntity() != null) {
            l = (LivingEntity)mm4.getMythicEntity().applyOptions((Entity)l);
        }
        AbstractEntity abstractEntity = BukkitAdapter.adapt((Entity)l);
        MythicBukkit.inst().getMobManager();
        ActiveMob am = new ActiveMob(abstractEntity, mm4, MobExecutor.getMythicMobLevel(mm4, BukkitAdapter.adapt((Entity)l)));
        this.mobRegistry.get().put(l.getUniqueId(), am);
        l = (LivingEntity)mm4.applyMobOptions(am, am.getLevel());
        l = (LivingEntity)mm4.applyMobVolatileOptions(am);
        new TriggeredSkill(SkillTriggers.SPAWN, am, null);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation b, int radiusXZ, int radiusY, int mob_height, boolean Ymod, boolean onSurface) {
        Location base = BukkitAdapter.adapt(b);
        if (radiusXZ <= 0) {
            radiusXZ = 1;
        }
        if (radiusY <= 0) {
            radiusY = 1;
        }
        double x = base.getX() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
        double z = base.getZ() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
        double y = Ymod ? base.getY() - (double)radiusY + (double)Numbers.randomInt(radiusY * 2) : base.getY() + (double)Numbers.randomInt(radiusY);
        Location loc = new Location(base.getWorld(), x, y, z);
        if (loc.getBlock().getType().isSolid()) {
            int j = 10;
            while (loc.getBlock().getType().isSolid()) {
                x = base.getX() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
                z = base.getZ() - (double)radiusXZ + (double)Numbers.randomInt(radiusXZ * 2);
                y = Ymod ? base.getY() - (double)radiusY + (double)Numbers.randomInt(radiusY * 2) : base.getY() + (double)Numbers.randomInt(radiusY);
                loc = new Location(base.getWorld(), x, y, z);
                if (--j != 0) continue;
                loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
                break;
            }
        }
        if (onSurface && !loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
            int highestY = loc.getWorld().getHighestBlockYAt(loc);
            if ((double)highestY <= loc.getY()) {
                loc.setY((double)(highestY + 1));
            } else {
                int j = 10;
                while (!loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                    if (j == 0) {
                        loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
                        break;
                    }
                    loc.setY(loc.getY() - 1.0);
                    --j;
                }
            }
        }
        return BukkitAdapter.adapt(loc);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radiusXZ, int radiusY, int mob_height, boolean yMod) {
        return MobExecutor.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, yMod, false);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radiusXZ, int radiusY, int mob_height) {
        return MobExecutor.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, true, false);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, int radius, int mob_height) {
        return MobExecutor.findSafeSpawnLocation(base, radius, radius, mob_height, true, false);
    }

    public Collection<ActiveMob> getMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean getInCombat(ActiveMob am) {
        return this.activeMobsInCombat.containsKey(am.getUniqueId());
    }

    public void setInCombat(ActiveMob am, boolean b) {
        if (b) {
            this.activeMobsInCombat.put(am.getUniqueId(), am);
        } else {
            this.activeMobsInCombat.remove(am.getUniqueId());
        }
    }

    public void saveCachedActiveMobs() {
        Schedulers.async().run(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Saving all active Mythic Mobs...", new Object[0]);
            this.mobRegistry.save();
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "All active mobs have been saved!", new Object[0]);
        });
    }

    public List<LivingEntity> getAllMythicEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (World w : Bukkit.getWorlds()) {
            for (LivingEntity e : w.getLivingEntities()) {
                if (!this.mobRegistry.get().isActiveMob(e.getUniqueId())) continue;
                list.add(e);
            }
        }
        return list;
    }

    @Override
    public Optional<MythicMob> getMythicMob(String type) {
        return Optional.ofNullable(this.mmList.getOrDefault(type, null));
    }

    public MobStack getMythicMobStack(String s2) {
        for (MobStack ML : this.listMobStacks) {
            if (!ML.getName().equals(s2)) continue;
            return ML;
        }
        return null;
    }

    public static int getMythicMobLevel(MythicMob mm4, AbstractEntity l) {
        int si;
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobLevel");
        if (o != null && (si = o.getScore(l.getUniqueId().toString()).getScore()) > 0) {
            return si;
        }
        int level = 1;
        if (!(mm4.getPerLevelHealth() > 0.0)) {
            return 1;
        }
        double health = l.getMaxHealth() - mm4.getHealth().get();
        return level += (int)(health / mm4.getPerLevelHealth());
    }

    public static void setMetaData(AbstractEntity abstractEntity, String s2, String key) {
        BukkitAdapter.adapt(abstractEntity).setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)MythicBukkit.inst(), (Object)s2));
    }

    public MythicMob determineMobType(AbstractEntity l) {
        List list = l.getBukkitEntity().getMetadata("mobname");
        MythicMob mm4 = null;
        for (MetadataValue mv : list) {
            mm4 = this.mmList.get(mv);
            if (mm4 == null) continue;
            return mm4;
        }
        if (l.getCustomName() == null) {
            return null;
        }
        mm4 = this.mmDisplayLookup.get(l.getCustomName());
        if (mm4 != null) {
            return mm4;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName().toString();
            search = search.replace("[", "\\[");
            search = search.replace("]", "\\]");
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = search.replace("<mob.level>", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            try {
                if (!l.getCustomName().toString().matches(search) || !(MM.getHealth().get() <= l.getMaxHealth())) continue;
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MythicMob getMythicMobByDisplayCompat(AbstractEntity l) {
        if (l.getCustomName() == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Attempting to match mob for compatibility: " + l.getCustomName().toString(), new Object[0]);
        MythicMob mm4 = this.mmDisplayLookup.get(l.getCustomName());
        if (mm4 != null) {
            return mm4;
        }
        mm4 = this.determineMobType(l);
        if (mm4 != null) {
            return mm4;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName().toString();
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            try {
                String name = ChatColor.translateAlternateColorCodes((char)'&', (String)l.getCustomName().toString());
                if (!name.matches(search)) continue;
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String convertMobTypeAliases(String s2) {
        s2 = s2.toLowerCase();
        s2 = s2.replace("zombievillager", "ZOMBIE_VILLAGER");
        s2 = s2.replace("villagezombie", "ZOMBIE_VILLAGER");
        s2 = s2.replace("babydrowned", "BABY_DROWNED");
        s2 = s2.replace("babyvillagezombie", "BABY_ZOMBIE_VILLAGER");
        s2 = s2.replace("babypigzombie", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babyzombiepig", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babyzombiepigman", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babypigzombievillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombiepigvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombiepigmanvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombie", "BABY_ZOMBIE");
        s2 = s2.replace("cavespider", "CAVE_SPIDER");
        s2 = s2.replace("enderdragon", "ENDER_DRAGON");
        s2 = s2.replace("glowsquid", "GLOW_SQUID");
        s2 = s2.replace("glowingsquid", "GLOW_SQUID");
        s2 = s2.replace("irongolem", "IRON_GOLEM");
        s2 = s2.replace("lavaslime", "MAGMA_CUBE");
        s2 = s2.replace("magmacube", "MAGMA_CUBE");
        s2 = s2.replace("mooshroom", "MUSHROOM_COW");
        s2 = s2.replace("mushroomcow", "MUSHROOM_COW");
        s2 = s2.replace("pigzombie", "PIG_ZOMBIE");
        s2 = s2.replace("zombiepig", "PIG_ZOMBIE");
        s2 = s2.replace("zombiepigman", "PIG_ZOMBIE");
        s2 = s2.replace("zombified_piglin", "PIG_ZOMBIE");
        s2 = s2.replace("pigzombievillager", "PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("zombiepigvillager", "PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("zombiepigmanvillager", "PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("tnt", "PRIMED_TNT");
        s2 = s2.replace("tropicalfish", "TROPICAL_FISH");
        s2 = s2.replace("skeletalhorse", "SKELETON_HORSE");
        s2 = s2.replace("skeletonhorse", "SKELETON_HORSE");
        s2 = s2.replace("zombiehorse", "ZOMBIE_HORSE");
        s2 = s2.replace("witherskeleton", "WITHER_SKELETON");
        return s2;
    }

    public WrappedJsonFile<MobRegistry> getMobRegistry() {
        return this.mobRegistry;
    }
}

