/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.concurrent.ConcurrentHashMap;

public class WorldScaling {
    private boolean enabled;
    private String world;
    private double scaleFactor_perBlocksFromSpawn;
    public static ConcurrentHashMap<String, WorldScaling> worldSettings = new ConcurrentHashMap();

    public WorldScaling(String world, MythicConfig mc) {
        this.world = world;
        this.enabled = mc.getBoolean("Enabled", true);
        this.scaleFactor_perBlocksFromSpawn = mc.getDouble("PerBlocksFromSpawn", -1.0);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** WorldScaling for world Enabled: " + this.enabled, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** WorldScaling for world perBlocksFromSpawn: " + this.scaleFactor_perBlocksFromSpawn, new Object[0]);
    }

    public WorldScaling(String world) {
        this.world = world;
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getWorldName() {
        return this.world;
    }

    public double getScaleFactor_BlocksFromSpawn() {
        return this.scaleFactor_perBlocksFromSpawn;
    }

    public static void initialize(String world, MythicConfig mc) {
        WorldScaling ws = new WorldScaling(world, mc);
        worldSettings.put(world, ws);
    }

    public static WorldScaling get(String world) {
        if (worldSettings.containsKey(world)) {
            return worldSettings.get(world);
        }
        if (worldSettings.contains("Default")) {
            return worldSettings.get("Default");
        }
        WorldScaling ws = new WorldScaling(world);
        worldSettings.put(world, ws);
        return ws;
    }

    public static void reset() {
        worldSettings.clear();
    }

    public static int getLevelBonus(AbstractLocation l) {
        WorldScaling ws = WorldScaling.get(l.getWorld().getName());
        if (!ws.isEnabled()) {
            return 1;
        }
        int lvl = 1;
        if (ws.getScaleFactor_BlocksFromSpawn() > 0.0) {
            double d = l.distance2D(l.getWorld().getSpawnLocation());
            lvl = (int)((double)lvl + Math.floor(d / ws.getScaleFactor_BlocksFromSpawn()));
        }
        return lvl;
    }
}

