/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.util.ConfigManager;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.utils.Schedulers;
import java.util.UUID;
import org.bukkit.entity.Entity;

public class MEModel
extends MobModel {
    private String id;
    private String mode = "A";
    private String nameplate = "";
    private double stepHeight = 0.5;
    private int viewRadius = 0;
    private boolean useHitbox = true;
    private boolean invisible = true;
    private boolean doDamageTint = true;
    private boolean canDrive = false;
    private boolean canRide = false;
    private boolean lockPitch = false;
    private boolean lockYaw = false;

    public MEModel(MythicMob baseMob, MythicConfig config) {
        super(baseMob, config);
        if (config.isConfigurationSection("Model")) {
            this.id = config.getString("Model.Id", null);
            this.nameplate = config.getString("Model.Nameplate", null);
            this.stepHeight = config.getDouble("Model.Step", 0.5);
            this.viewRadius = config.getInteger("Model.ViewRadius", 0);
            this.useHitbox = config.getBoolean("Model.Hitbox", true);
            this.invisible = config.getBoolean("Model.Invisible", true);
            this.doDamageTint = config.getBoolean("Model.DamageTint", false);
            this.canDrive = config.getBoolean("Model.Drive", false);
            this.canRide = config.getBoolean("Model.Ride", false);
            this.lockPitch = config.getBoolean("Model.LockPitch", false);
            this.lockYaw = config.getBoolean("Model.LockYaw", false);
            Schedulers.sync().runLater(() -> {
                this.mode = config.getString("Model.Mode", ModelEngineAPI.api.getConfigManager().animation.name());
            }, 1L);
        } else {
            this.id = config.getString("Model");
        }
    }

    @Override
    public void apply(AbstractEntity entity) {
        if (this.id == null) {
            MythicLogger.error("ModelEngine ID not specified");
            return;
        }
        Entity bukkitTarget = BukkitAdapter.adapt(entity);
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity((UUID)bukkitTarget.getUniqueId());
        String modelId = this.id.toLowerCase();
        ConfigManager.AnimationMode mode = ConfigManager.AnimationMode.get((String)this.mode);
        if (ModelEngineAPI.getModelBlueprint((String)modelId) == null) {
            return;
        }
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity((Entity)bukkitTarget);
        } else {
            modeledEntity.clearModels();
        }
        ActiveModel model = ModelEngineAPI.createActiveModel((String)modelId);
        model.setAnimationMode(mode);
        model.setDamageTint(this.doDamageTint);
        if (!this.useHitbox) {
            float width = modeledEntity.getWidth();
            float height = modeledEntity.getHeight();
            float eye = modeledEntity.getEye();
            modeledEntity.addActiveModel(model);
            modeledEntity.overrideHitbox(width, height, eye);
        } else {
            modeledEntity.addActiveModel(model);
        }
        modeledEntity.detectPlayers();
        modeledEntity.setStepHeight(this.stepHeight);
        if (this.viewRadius > 0) {
            modeledEntity.getRangeManager().setRenderDistance(this.viewRadius);
        }
        modeledEntity.getMountHandler().setSteerable(this.canDrive);
        modeledEntity.getMountHandler().setCanCarryPassenger(this.canRide);
        modeledEntity.setInvisible(this.invisible);
        modeledEntity.lockPitch(this.lockPitch);
        modeledEntity.lockYaw(this.lockYaw);
    }
}

