/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.players;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.SerializingComponent;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.players.factions.FactionProvider;
import io.lumine.mythic.core.players.factions.PermissionFactionProvider;
import io.lumine.mythic.utils.Events;
import io.lumine.mythic.utils.serialization.WrappedJsonFile;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerManager
extends SerializingComponent {
    protected Map<UUID, WrappedJsonFile<PlayerData>> playerData = Maps.newConcurrentMap();
    protected Map<UUID, PlayerMovementData> playerPositions = Maps.newConcurrentMap();
    protected FactionProvider factionProvider = new PermissionFactionProvider();
    private ReentrantLock lock = new ReentrantLock();

    public PlayerManager(MythicBukkit core) {
        super(core);
        Events.subscribe(PlayerMoveEvent.class, EventPriority.MONITOR).filter(event -> !event.isCancelled()).handler(event -> this.playerPositions.put(event.getPlayer().getUniqueId(), new PlayerMovementData(event.getFrom(), event.getTo()))).bindWith(this);
        Events.subscribe(PlayerQuitEvent.class).handler(event -> {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            if (this.playerData.containsKey(uuid)) {
                WrappedJsonFile<PlayerData> entry = this.playerData.remove(uuid);
                entry.get().getVariables().unload();
                entry.save();
            }
            this.playerPositions.remove(uuid);
        }).bindWith(this);
    }

    @Override
    public void load(MythicBukkit plugin) {
    }

    @Override
    public void unload() {
        this.playerData.forEach((uuid, file) -> {
            if (file == null) {
                return;
            }
            ((PlayerData)file.get()).getVariables().unload();
            file.save();
        });
    }

    public void registerFactionProvider(FactionProvider provider) {
        this.factionProvider = provider;
    }

    public PlayerData getPlayerData(AbstractPlayer player) {
        this.lock.lock();
        try {
            if (!this.playerData.containsKey(player.getUniqueId())) {
                PlayerData playerData = this.loadPlayerData(player).get();
                return playerData;
            }
            PlayerData playerData = this.playerData.get(player.getUniqueId()).get();
            return playerData;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected WrappedJsonFile<PlayerData> loadPlayerData(AbstractPlayer player) {
        return this.playerData.compute(player.getUniqueId(), (k, v) -> v == null ? this.createPlayerData((UUID)k) : v);
    }

    private WrappedJsonFile<PlayerData> createPlayerData(UUID uuid) {
        File playerDir = this.getModuleDirectory("players");
        File playerFile = new File(playerDir, uuid.toString() + ".json");
        if (!playerDir.exists()) {
            playerDir.mkdir();
        }
        return this.loadFile(playerFile, PlayerData.class);
    }

    public void saveAll() {
        this.playerData.forEach((uuid, file) -> {
            if (file == null) {
                return;
            }
            ((PlayerData)file.get()).getVariables().clean();
            file.save();
        });
    }

    public Map<UUID, PlayerMovementData> getPlayerPositions() {
        return this.playerPositions;
    }

    public FactionProvider getFactionProvider() {
        return this.factionProvider;
    }

    public class PlayerMovementData {
        private final long lastMovementTime = System.currentTimeMillis();
        private final Location from;
        private final Location to;

        public PlayerMovementData(Location from, Location to) {
            this.from = from;
            this.to = to;
        }

        public long getLastMovementTime() {
            return this.lastMovementTime;
        }

        public Location getFrom() {
            return this.from;
        }

        public Location getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerMovementData)) {
                return false;
            }
            PlayerMovementData other = (PlayerMovementData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLastMovementTime() != other.getLastMovementTime()) {
                return false;
            }
            Location this$from = this.getFrom();
            Location other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            Location this$to = this.getTo();
            Location other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlayerMovementData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastMovementTime = this.getLastMovementTime();
            result = result * 59 + (int)($lastMovementTime >>> 32 ^ $lastMovementTime);
            Location $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            Location $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        public String toString() {
            return "PlayerManager.PlayerMovementData(lastMovementTime=" + this.getLastMovementTime() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

