/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillHelper;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.conditions.ConditionAction;
import io.lumine.mythic.core.skills.targeters.ConsoleTargeter;
import io.lumine.mythic.core.skills.targeters.CustomTargeter;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.skills.targeters.OriginTargeter;
import io.lumine.mythic.core.skills.targeters.TriggerLocationTargeter;
import io.lumine.mythic.utils.numbers.Numbers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;

public abstract class AbstractSkill {
    protected ThreadSafetyLevel threadSafetyLevel = ThreadSafetyLevel.EITHER;
    public static long cooldownTimer = 0L;
    private final MythicBukkit plugin;
    private final SkillExecutor manager;
    protected UUID uuid;
    protected float cooldown = 0.0f;
    protected float power = 0.0f;
    protected float powerScale = 1.0f;
    protected PlaceholderInt delay = PlaceholderInt.of("0");
    protected PlaceholderInt repeat = PlaceholderInt.of("0");
    protected PlaceholderInt repeatInterval = PlaceholderInt.of("0");
    protected PlaceholderDouble targetInterval = PlaceholderDouble.of("0");
    protected float chance = 1.0f;
    protected String healthMod = null;
    protected boolean powerSplitBetweenTargets = false;
    protected SkillTrigger trigger = SkillTriggers.COMBAT;
    protected boolean sourceIsOrigin = false;
    protected HashMap<UUID, Long> cooldowns = new HashMap();
    protected Optional<SkillTargeter> targeter = Optional.empty();
    protected boolean target_creative = false;
    protected List<SkillCondition> conditions = null;
    protected List<SkillCondition> conditionsTarget = null;
    protected List<SkillCondition> conditionsTrigger = null;

    public AbstractSkill(SkillExecutor manager) {
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.uuid = UUID.randomUUID();
    }

    public boolean onCooldown(SkillCaster skillCaster) {
        if (this.cooldown == 0.0f) {
            return false;
        }
        long next = this.cooldowns.getOrDefault(skillCaster.getEntity().getUniqueId(), 0L);
        return next >= cooldownTimer;
    }

    public float getCooldown(SkillCaster skillCaster) {
        if (this.cooldown == 0.0f) {
            return 0.0f;
        }
        long next = this.cooldowns.getOrDefault(skillCaster.getEntity().getUniqueId(), 0L);
        if (next < cooldownTimer) {
            return 0.0f;
        }
        return (next - cooldownTimer) / 20L;
    }

    public void setCooldown(SkillCaster skillCaster, float cooldown) {
        if (cooldown > 0.0f) {
            this.cooldowns.put(skillCaster.getEntity().getUniqueId(), (long)((float)cooldownTimer + cooldown * 20.0f - 2.0f));
        } else {
            this.cooldowns.remove(skillCaster.getEntity().getUniqueId());
        }
    }

    protected boolean rollChance() {
        if (this.chance == 1.0f) {
            return true;
        }
        return !(Numbers.randomDouble() > (double)this.chance);
    }

    protected boolean checkHealth(SkillCaster skillCaster) {
        String[] healthparts;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Performing Health Check", new Object[0]);
        if (this.healthMod == null) {
            return true;
        }
        String[] stringArray = healthparts = this.healthMod.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double bosshp;
            String health;
            String healthT = health = stringArray[i];
            String skillstr = skillCaster.getEntity().getUniqueId() + this.uuid.toString() + "#" + health;
            healthT = healthT.replace("%", "");
            healthT = healthT.replace("<", "");
            healthT = healthT.replace(">", "");
            healthT = healthT.replace("=", "");
            if (!(healthT = healthT.replace("-", "")).matches("[-+]?[0-9]*.?[0-9]+")) {
                return true;
            }
            double hp = Double.parseDouble(healthT);
            if (health.endsWith("%")) {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / 100.0;
            } else {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / skillCaster.getEntity().getMaxHealth();
            }
            if (health.startsWith(">")) {
                health = health.replace(">", "");
                if (!(bosshp > hp)) continue;
                return true;
            }
            if (health.startsWith("<")) {
                health = health.replace("<", "");
                if (!(bosshp < hp)) continue;
                return true;
            }
            if (health.startsWith("=")) {
                if ((health = health.replace("=", "")).contains("-")) {
                    String[] hps = health.split("-");
                    double hp1 = hps[0].endsWith("%") ? Double.parseDouble(hps[0].substring(0, hps[0].length() - 1)) / 100.0 : Double.parseDouble(hps[0].substring(0, hps[0].length())) / skillCaster.getEntity().getMaxHealth();
                    double hp2 = hps[1].endsWith("%") ? Double.parseDouble(hps[1].substring(0, hps[1].length() - 1)) / 100.0 : Double.parseDouble(hps[1].substring(0, hps[1].length())) / skillCaster.getEntity().getMaxHealth();
                    if (hp2 > hp1) {
                        double hp3 = hp1;
                        hp1 = hp2;
                        hp2 = hp3;
                    }
                    if (!(bosshp > hp2) || !(bosshp < hp1)) continue;
                    return true;
                }
                if (!(bosshp <= hp) || !(skillCaster.getEntity().getHealth() > hp) || SkillHelper.hasUsedSkill(skillstr, skillCaster.getEntity())) continue;
                if (skillCaster instanceof ActiveMob && !((ActiveMob)skillCaster).getType().getRepeatAllSkills().booleanValue()) {
                    MythicBukkit.inst().getMobManager();
                    MobExecutor.setMetaData(skillCaster.getEntity(), skillstr, skillstr);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean checkSkillTrigger(SkillTrigger trigger) {
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", trigger, this.trigger);
        if (trigger.equals(SkillTriggers.SIGNAL)) {
            return true;
        }
        if (SkillTriggers.TIMER.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.API.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SIGNAL.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SPAWN.equals(this.trigger)) {
            return trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.LOAD;
        }
        if (SkillTriggers.COMBAT.equals(this.trigger)) {
            return trigger == SkillTriggers.DAMAGED || trigger == SkillTriggers.ATTACK;
        }
        if (SkillTriggers.KILL.equals(this.trigger)) {
            return trigger == SkillTriggers.KILL || trigger == SkillTriggers.KILLPLAYER;
        }
        if (SkillTriggers.DEFAULT.equals(this.trigger)) {
            return trigger == SkillTriggers.DAMAGED || trigger == SkillTriggers.ATTACK || trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.LOAD || trigger == SkillTriggers.DEATH || trigger == SkillTriggers.TIMER;
        }
        return this.trigger.equals(trigger);
    }

    protected boolean checkSkillTrigger(SkillMetadata meta) {
        SkillTrigger trigger = meta.getCause();
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", trigger, this.trigger);
        if (trigger.equals(SkillTriggers.SIGNAL)) {
            return true;
        }
        if (SkillTriggers.TIMER.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.API.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SIGNAL.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SPAWN.equals(this.trigger)) {
            return trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.LOAD;
        }
        if (SkillTriggers.COMBAT.equals(this.trigger)) {
            return trigger == SkillTriggers.DAMAGED || trigger == SkillTriggers.ATTACK;
        }
        if (SkillTriggers.KILL.equals(this.trigger)) {
            return trigger == SkillTriggers.KILL || trigger == SkillTriggers.KILLPLAYER;
        }
        if (SkillTriggers.DEFAULT.equals(this.trigger)) {
            return trigger == SkillTriggers.DAMAGED || trigger == SkillTriggers.ATTACK || trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.LOAD || trigger == SkillTriggers.DEATH || trigger == SkillTriggers.TIMER;
        }
        return this.trigger.equals(trigger);
    }

    protected SkillTrigger parseSkillTrigger(String strTrigger) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTrigger {0}", strTrigger);
        String search = strTrigger.contains(":") ? strTrigger.substring(3, strTrigger.indexOf(":")).toUpperCase() : strTrigger.substring(3).toUpperCase();
        return SkillTriggers.get(search);
    }

    protected SkillTargeter parseSkillTargeter(String strTarget) {
        return this.getPlugin().getSkillManager().getTargeter(strTarget);
    }

    protected SkillCondition parseSkillCondition(String strCondition) {
        String search = strCondition.substring(1);
        boolean n = false;
        if (search.startsWith("!")) {
            search = search.substring(1);
            n = true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillCondition {0}", search);
        SkillCondition cond = this.getPlugin().getSkillManager().getCondition(search);
        if (cond != null && n) {
            cond.setAction(ConditionAction.FALSE);
        }
        return cond;
    }

    public void setTargetsCreativePlayers(boolean b) {
        this.target_creative = b;
    }

    public boolean targetsCreativePlayers() {
        return this.target_creative;
    }

    public SkillMetadata evaluateTargets(SkillMetadata data) {
        if (this.targeter.isPresent()) {
            return this.evaluateTargets(data, this.targeter.get());
        }
        return data;
    }

    public SkillMetadata evaluateTargets(SkillMetadata data, SkillTargeter targeter) {
        block12: {
            if (targeter instanceof CustomTargeter && ((CustomTargeter)targeter).getTargeter().isPresent()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillTargeter is a CUSTOM targeter", new Object[0]);
                targeter = ((CustomTargeter)targeter).getTargeter().get();
            }
            if (targeter instanceof IEntitySelector) {
                try {
                    data.setEntityTargets(((IEntitySelector)targeter).getEntities(data));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": EntityTargeter found {0} targets", data.getEntityTargets().size());
                    ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
                }
                catch (IllegalArgumentException ex) {
                    data.setEntityTargets(Sets.newHashSet());
                    MythicBukkit.inst().getConfiguration();
                    if (ConfigManager.debugLevel <= 0) break block12;
                    ex.printStackTrace();
                }
            }
        }
        if (targeter instanceof ILocationSelector) {
            data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": LocationTargeter found {0} targets", data.getLocationTargets().size());
            ((ILocationSelector)targeter).filter(data);
        } else if (targeter instanceof OriginTargeter) {
            data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting origin", new Object[0]);
        } else if (targeter instanceof TriggerLocationTargeter) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting trigger location", new Object[0]);
            HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
            lTargets.add(data.getTrigger().getLocation());
            data.setLocationTargets(lTargets);
        }
        if (targeter instanceof ConsoleTargeter) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting console", new Object[0]);
            data.setEntityTargets(null);
            data.setLocationTargets(null);
        }
        if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty() && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getEntityTargets().size());
        }
        if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty() && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getLocationTargets().size());
        }
        return data;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return this.threadSafetyLevel;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public SkillExecutor getManager() {
        return this.manager;
    }

    public SkillTrigger getTrigger() {
        return this.trigger;
    }

    public Optional<SkillTargeter> getTargeter() {
        return this.targeter;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public List<SkillCondition> getConditionsTarget() {
        return this.conditionsTarget;
    }

    public List<SkillCondition> getConditionsTrigger() {
        return this.conditionsTrigger;
    }

    protected static class DelayedSkill
    implements Runnable {
        private SkillMetadata data;
        private Queue<SkillMechanic> skills;
        private boolean cancelled;

        public DelayedSkill(SkillMetadata data, Queue<SkillMechanic> skills) {
            this.data = data;
            this.skills = skills;
            this.cancelled = false;
        }

        public void cancel() {
            this.skills = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                try {
                    if (this.data.getCaster().getEntity().isDead() && !this.data.getCause().equals(SkillTriggers.DEATH) && !this.data.getCause().equals(SkillTriggers.DESPAWNED) && !this.data.getCause().equals(SkillTriggers.EXPLODE)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Mob is dead, cancelling skill (cause = {0})", this.data.getCause());
                        this.cancel();
                        return;
                    }
                    MetaSkill.execute(this.data, this.skills);
                }
                catch (NullPointerException ex) {
                    this.cancel();
                    ex.printStackTrace();
                }
                return;
            }
        }
    }
}

